/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.entities;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityEnergyBlast
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public float damage;
    public Color color;
    public int maxLife = 600;

    public EntityEnergyBlast(World worldIn) {
        super(worldIn);
    }

    public EntityEnergyBlast(World worldIn, EntityLivingBase throwerIn, float damage, Color color) {
        super(worldIn, throwerIn);
        this.damage = damage;
        this.color = color;
    }

    public void func_70030_z() {
        double speed = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72438_d(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s));
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > this.maxLife || speed < 0.01)) {
            this.func_70106_y();
        }
        super.func_70030_z();
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        super.func_184538_a(entityThrower, rotationPitchIn, rotationYawIn, pitchOffset, velocity, inaccuracy);
        if (entityThrower instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)entityThrower;
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result == null || this.field_70128_L) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (result.field_72308_g == this.field_70192_c) {
                return;
            }
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            PlayerHelper.spawnParticleForAll(this.func_130014_f_(), 50.0, EnumParticleTypes.SMOKE_NORMAL, true, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 0.01f, 5, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 1.0E-5f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", this.damage);
        compound.func_74768_a("Color_R", this.color.getRed());
        compound.func_74768_a("Color_G", this.color.getGreen());
        compound.func_74768_a("Color_B", this.color.getBlue());
        compound.func_74757_a("Invisible", this.func_82150_aj());
        compound.func_74768_a("Lifetime", this.maxLife);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("Damage");
        this.color = new Color(compound.func_74762_e("Color_R"), compound.func_74762_e("Color_G"), compound.func_74762_e("Color_B"));
        this.func_82142_c(compound.func_74767_n("Invisible"));
        this.maxLife = compound.func_74762_e("Lifetime");
        if (this.maxLife <= 0) {
            this.maxLife = 600;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public boolean func_70090_H() {
        return false;
    }
}

