/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.gui;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainerSuperpower;
import lucraft.mods.lucraftcore.superpowers.gui.GuiAbilityList;
import lucraft.mods.lucraftcore.superpowers.gui.InventoryTabSuperpowerAbilities;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.tabs.TabRegistry;
import lucraft.mods.lucraftcore.util.container.ContainerDummy;
import lucraft.mods.lucraftcore.util.gui.buttons.GuiButton10x;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiAbilities
extends GuiContainer {
    public static final ResourceLocation TEX = new ResourceLocation("lucraftcore", "textures/gui/abilities.png");
    public EntityPlayer player;
    public Ability.EnumAbilityContext context;
    public AbilityContainer data;
    public GuiAbilityList list;
    public List<Ability> abilities;
    public int mouseX;
    public int mouseY;
    public int xSize_ = 256;
    public int ySize_ = 189;
    public int selectedAbility = -1;

    public GuiAbilities(EntityPlayer player, Ability.EnumAbilityContext context) {
        super((Container)new ContainerDummy());
        this.player = player;
        this.context = context;
        this.data = Ability.getAbilityContainer(context, (EntityLivingBase)player);
        this.abilities = ImmutableList.copyOf(this.data.getAbilities());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 256;
        this.field_147000_g = 189;
        this.xSize_ = this.field_146999_f;
        this.ySize_ = this.field_147000_g;
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton10x(32, i + 239, j + 90, "?"));
        this.list = new GuiAbilityList(this.field_146297_k, this);
        int cornerX = i;
        int cornerY = j;
        TabRegistry.updateTabValues(cornerX, cornerY, InventoryTabSuperpowerAbilities.class);
        TabRegistry.addTabsToList(this.field_146292_n);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.list != null) {
            this.list.handleMouseInput(this.mouseX, this.mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(TEX);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(i + 80), (float)(j + 46), (float)0.0f);
        GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
        if (this.context == Ability.EnumAbilityContext.SUPERPOWER && SuperpowerHandler.hasSuperpower((EntityLivingBase)this.player)) {
            SuperpowerHandler.getSuperpower((EntityLivingBase)this.player).renderIcon(this.field_146297_k, 0, 0);
        }
        GlStateManager.func_179121_F();
        this.field_146297_k.func_110434_K().func_110577_a(TEX);
        if (this.context == Ability.EnumAbilityContext.SUPERPOWER && SuperpowerHandler.getSuperpower((EntityLivingBase)this.player).canLevelUp() && this.data != null && this.data instanceof AbilityContainerSuperpower) {
            Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)this.player);
            AbilityContainerSuperpower data = (AbilityContainerSuperpower)this.data;
            this.func_73729_b(i + 125, j + 171, 0, 215, 81, 5);
            float xp = (float)data.getXP() / (float)superpower.getXPForLevel(data.getLevel() + 1);
            if (data.getLevel() == superpower.getMaxLevel()) {
                xp = 1.0f;
            }
            this.func_73729_b(i + 125, j + 171, 0, 220, (int)(xp * 81.0f), 5);
            LCRenderHelper.drawStringWithOutline("" + data.getLevel(), i + 112, j + 170, 10014827, 531473);
            if (data.getLevel() < superpower.getMaxLevel()) {
                boolean unicode = this.field_146297_k.field_71466_p.func_82883_a();
                this.field_146297_k.field_71466_p.func_78264_a(true);
                String xpProgress = data.getXP() + "/" + superpower.getXPForLevel(data.getLevel() + 1);
                int length = 120 - this.field_146297_k.field_71466_p.func_78256_a(xpProgress) / 2;
                this.field_146297_k.field_71466_p.func_78276_b(xpProgress, i + length + 45, j + 175, 0x555555);
                this.field_146297_k.field_71466_p.func_78264_a(unicode);
            }
        }
        String name = TextFormatting.UNDERLINE + (this.context == Ability.EnumAbilityContext.SUPERPOWER && SuperpowerHandler.hasSuperpower((EntityLivingBase)this.player) ? SuperpowerHandler.getSuperpower((EntityLivingBase)this.player).getDisplayName() : (this.context == Ability.EnumAbilityContext.SUIT && SuitSet.getSuitSet((EntityLivingBase)this.player) != null ? SuitSet.getSuitSet((EntityLivingBase)this.player).getDisplayName() : ""));
        int x = this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(name) / 2;
        this.field_146297_k.field_71466_p.func_78276_b(name, i + x, j + 10, 0x373737);
        if (this.list != null) {
            Ability ability;
            this.list.drawScreen(mouseX, mouseY, partialTicks);
            GuiButton info = null;
            for (GuiButton button : this.field_146292_n) {
                if (!(button instanceof GuiButton10x)) continue;
                info = button;
            }
            if (info != null && this.selectedAbility > -1 && info.field_146124_l && mouseX >= info.field_146128_h && mouseX <= info.field_146128_h + info.field_146120_f && mouseY >= info.field_146129_i && mouseY <= info.field_146129_i + info.field_146121_g && (ability = this.abilities.get(this.selectedAbility)) != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (String s : ability.getDisplayDescription().split("\n")) {
                    for (String s2 : this.field_146297_k.field_71466_p.func_78271_c(s, 250)) {
                        list.add(s2);
                    }
                }
                if (this.field_146297_k.field_71474_y.field_82882_x) {
                    list.add(TextFormatting.DARK_GRAY + "ID: " + ability.getAbilityEntry().getRegistryName().toString());
                    list.add(TextFormatting.DARK_GRAY + "Key: " + ability.getKey());
                }
                this.func_146283_a(list, mouseX - 250, mouseY + 10);
            }
        }
    }
}

