/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.util.helper.LCEntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncAbilityContainer
implements IMessage {
    public UUID playerUUID;
    public Ability.EnumAbilityContext context;
    public NBTTagCompound nbt;

    public MessageSyncAbilityContainer() {
    }

    public MessageSyncAbilityContainer(EntityLivingBase entity, AbilityContainer container) {
        this.playerUUID = entity.getPersistentID();
        this.context = container.context;
        this.nbt = container.serializeNBTSync();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.context = Ability.EnumAbilityContext.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.context.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncAbilityContainer> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, MessageSyncAbilityContainer message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                AbilityContainer container;
                Entity en;
                if (message != null && ctx != null && (en = LCEntityHelper.getEntityByUUID(LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p, message.playerUUID)) != null && en instanceof EntityLivingBase && message.context != null && (container = Ability.getAbilityContainer(message.context, (EntityLivingBase)en)) != null) {
                    container.deserializeNBTSync(message.nbt);
                }
            });
            return null;
        }
    }
}

