/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.suitsets;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.addonpacks.AddonPackRecipeReader;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.superpowers.ModuleSuperpowers;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncJsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.JsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.RegisterSuitSetEvent;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class AddonPackSuitSetReader {
    public static final List<JsonSuitSet> SUIT_SETS = new ArrayList<JsonSuitSet>();

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
            return;
        }
        if (e.getDirectory().equals("suitsets") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            try {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
                JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
                JsonSuitSet suit = new JsonSuitSet("name");
                suit.setRegistryName(e.getResourceLocation());
                suit.jsonOriginal = jsonobject;
                if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"conditions"), (JsonContext)new AddonPackRecipeReader.JsonContextExt(e.getResourceLocation().func_110624_b()))) {
                    return;
                }
                suit.deserialize(jsonobject, e.getResourceLocation());
                SUIT_SETS.add(suit);
            }
            catch (Exception e2) {
                LucraftCore.LOGGER.error("Wasn't able to read suit set '" + e.getFileName() + "' in addon pack '" + e.getPackFile().getName() + "': " + e2.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterSuitSets(RegisterSuitSetEvent e) {
        for (SuitSet suitSet : SUIT_SETS) {
            e.register(suitSet);
        }
        SUIT_SETS.clear();
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> e) {
        if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
            return;
        }
        for (ResourceLocation sets : SuitSet.REGISTRY.func_148742_b()) {
            if (!(SuitSet.REGISTRY.func_82594_a((Object)sets) instanceof JsonSuitSet)) continue;
            ((SuitSet)SuitSet.REGISTRY.func_82594_a((Object)sets)).registerItems(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent e) {
        if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
            return;
        }
        for (ResourceLocation sets : SuitSet.REGISTRY.func_148742_b()) {
            if (!(SuitSet.REGISTRY.func_82594_a((Object)sets) instanceof JsonSuitSet)) continue;
            ((SuitSet)SuitSet.REGISTRY.func_82594_a((Object)sets)).registerModels();
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
            return;
        }
        if (e.player instanceof EntityPlayerMP) {
            for (JsonSuitSet jss : SUIT_SETS) {
                LCPacketDispatcher.sendTo(new MessageSyncJsonSuitSet(jss, jss.jsonOriginal), (EntityPlayerMP)e.player);
            }
        }
    }
}

