/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.suitsets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityGenerator;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import lucraft.mods.lucraftcore.superpowers.suitsets.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.abilitybar.EnumAbilityBarColor;
import lucraft.mods.lucraftcore.util.creativetabs.CreativeTabRegistry;
import lucraft.mods.lucraftcore.util.helper.ItemHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JsonSuitSet
extends SuitSet {
    protected ResourceLocation parent;
    public JsonObject jsonOriginal;
    public ResourceLocation loc;
    public ItemArmor.ArmorMaterial material;
    public ITextComponent name;
    public ITextComponent desc;
    public Map<EntityEquipmentSlot, JsonSuitSetSlotInfo> slotInfos;
    public List<AbilityGenerator> abilityGenerators;
    public boolean parentAbilities;
    public List<Effect> effects;
    public NBTTagCompound data;
    public String tab;

    public JsonSuitSet(String name) {
        super(name);
    }

    public SuitSet getParent() {
        if (this.parent == null) {
            return null;
        }
        return (SuitSet)SuitSet.REGISTRY.func_82594_a((Object)this.parent);
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> e) {
        if (this.slotInfos.containsKey(EntityEquipmentSlot.HEAD)) {
            this.helmet = this.createItem(this, EntityEquipmentSlot.HEAD);
            e.getRegistry().register((IForgeRegistryEntry)this.helmet);
        }
        this.chestplate = this.createItem(this, EntityEquipmentSlot.CHEST);
        e.getRegistry().register((IForgeRegistryEntry)this.chestplate);
        if (this.slotInfos.containsKey(EntityEquipmentSlot.LEGS)) {
            this.legs = this.createItem(this, EntityEquipmentSlot.LEGS);
            e.getRegistry().register((IForgeRegistryEntry)this.legs);
        }
        if (this.slotInfos.containsKey(EntityEquipmentSlot.FEET)) {
            this.boots = this.createItem(this, EntityEquipmentSlot.FEET);
            e.getRegistry().register((IForgeRegistryEntry)this.boots);
        }
        CreativeTabRegistry.getOrCreateCreativeTab(this.tab, new ItemStack(this.getChestplate()));
    }

    @Override
    public ItemSuitSetArmor createItem(SuitSet suitSet, EntityEquipmentSlot slot) {
        if (this.getParent() != null) {
            return this.getParent().createItem(suitSet, slot);
        }
        return super.createItem(suitSet, slot);
    }

    @Override
    public String getUnlocalizedName() {
        return this.loc.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, EntityEquipmentSlot slot) {
        if (item != null && this.slotInfos.get((Object)slot).itemModel != null && !this.slotInfos.get((Object)slot).itemModelInfo.isEmpty()) {
            JsonSuitSetItemModelType type = this.slotInfos.get((Object)slot).itemModel;
            String s = this.slotInfos.get((Object)slot).itemModelInfo;
            if (type == JsonSuitSetItemModelType.MODEL) {
                ResourceLocation loc = new ResourceLocation(s);
                ItemHelper.registerItemModel(item, loc.func_110624_b(), loc.func_110623_a());
            }
            if (type == JsonSuitSetItemModelType.BLOCKSTATE) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(s), slot.toString().toLowerCase()));
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.name.func_150254_d();
    }

    @Override
    public String getDisplayNameForItem(Item item, ItemStack stack, EntityEquipmentSlot armorType, String origName) {
        return this.slotInfos.get((Object)armorType).name.func_150254_d();
    }

    @Override
    public List<String> getExtraDescription(ItemStack stack) {
        return this.desc == null ? null : Arrays.asList(this.desc.func_150254_d());
    }

    @Override
    public String getModId() {
        return this.loc.func_110624_b();
    }

    @Override
    public ItemArmor.ArmorMaterial getArmorMaterial(EntityEquipmentSlot slot) {
        return this.material;
    }

    @Override
    public boolean canOpenArmor(EntityEquipmentSlot slot) {
        return this.slotInfos.get((Object)slot).openable;
    }

    @Override
    public boolean showInCreativeTab() {
        return !this.tab.equalsIgnoreCase("none");
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return CreativeTabRegistry.getCreativeTab(this.tab);
    }

    @Override
    public boolean hasGlowyThings(EntityLivingBase entity, EntityEquipmentSlot slot) {
        if (this.slotInfos.containsKey(slot)) {
            return this.slotInfos.get((Object)slot).glow;
        }
        return super.hasGlowyThings(entity, slot);
    }

    @Override
    public float getGlowOpacity(SuitSet suitSet, EntityLivingBase entity, EntityEquipmentSlot slot) {
        if (this.getParent() != null) {
            return this.getParent().getGlowOpacity(suitSet, entity, slot);
        }
        return super.getGlowOpacity(suitSet, entity, slot);
    }

    @Override
    public ModelBiped getArmorModel(SuitSet suitSet, ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        if (this.getParent() != null) {
            return this.getParent().getArmorModel(suitSet, stack, entity, slot, light, smallArms, open);
        }
        return super.getArmorModel(suitSet, stack, entity, slot, light, smallArms, open);
    }

    @Override
    public float getArmorModelScale(EntityEquipmentSlot armorSlot) {
        if (this.slotInfos.containsKey(armorSlot) && this.slotInfos.get((Object)armorSlot).armor_model_scale > 0.0f) {
            return this.slotInfos.get((Object)armorSlot).armor_model_scale;
        }
        return super.getArmorModelScale(armorSlot);
    }

    @Override
    public String getArmorTexturePath(ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        String key;
        JsonSuitSetSlotInfo info = this.slotInfos.get(slot);
        String string = key = light ? "glow" : "normal";
        if (smallArms && info.textures.containsKey(key + "_smallarms")) {
            key = key + "_smallarms";
        }
        if (open && info.textures.containsKey(key + "_open")) {
            key = key + "_open";
        }
        return info.textures.containsKey(key) ? info.textures.get(key) : "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindArmorTexture(SuitSet suitSet, Entity entity, float f, float f1, float f2, float f3, float f4, float f5, ResourceLocation normalTex, ResourceLocation glowTex, boolean glow, EntityEquipmentSlot slot, boolean smallArms) {
        if (this.getParent() != null) {
            this.getParent().bindArmorTexture(suitSet, entity, f, f1, f2, f3, f4, f5, normalTex, glowTex, glow, slot, smallArms);
        } else {
            super.bindArmorTexture(suitSet, entity, f, f1, f2, f3, f4, f5, normalTex, glowTex, glow, slot, smallArms);
        }
    }

    @Override
    public Ability.AbilityMap addDefaultAbilities(EntityLivingBase entity, Ability.AbilityMap abilities, Ability.EnumAbilityContext context) {
        if (this.parentAbilities && this.getParent() != null) {
            this.getParent().addDefaultAbilities(entity, abilities, context);
        }
        for (AbilityGenerator ab : this.abilityGenerators) {
            Ability ability = ab.create(entity, abilities);
            if (ability == null) continue;
            abilities.put(ab.key, ability);
        }
        return super.addDefaultAbilities(entity, abilities, context);
    }

    @Override
    public void onEquip(SuitSet suitSet, EntityLivingBase player) {
        if (this.getParent() != null) {
            this.getParent().onEquip(suitSet, player);
        } else {
            super.onEquip(suitSet, player);
        }
    }

    @Override
    public void onUnequip(SuitSet suitSet, EntityLivingBase player) {
        if (this.getParent() != null) {
            this.getParent().onUnequip(suitSet, player);
        } else {
            super.onUnequip(suitSet, player);
        }
    }

    @Override
    public void onUpdate(SuitSet suitSet, EntityLivingBase player) {
        if (this.getParent() != null) {
            this.getParent().onUpdate(suitSet, player);
        } else {
            super.onUpdate(suitSet, player);
        }
    }

    @Override
    public List<Effect> getEffects() {
        return this.effects;
    }

    @Override
    public NBTTagCompound getData() {
        return this.data;
    }

    public JsonSuitSet deserialize(JsonObject jsonobject, ResourceLocation loc) throws Exception {
        JsonObject armor_material = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"armor_material");
        JsonArray damage_reduction = JsonUtils.func_151214_t((JsonObject)armor_material, (String)"damage_reduction_amounts");
        ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)loc.toString(), (String)"", (int)JsonUtils.func_151203_m((JsonObject)armor_material, (String)"durability"), (int[])new int[]{damage_reduction.get(0).getAsInt(), damage_reduction.get(1).getAsInt(), damage_reduction.get(2).getAsInt(), damage_reduction.get(3).getAsInt()}, (int)JsonUtils.func_151203_m((JsonObject)armor_material, (String)"enchantibility"), (SoundEvent)((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(JsonUtils.func_151200_h((JsonObject)armor_material, (String)"sound")))), (float)JsonUtils.func_151217_k((JsonObject)armor_material, (String)"toughness"));
        ITextComponent name = ITextComponent.Serializer.func_150699_a((String)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"name").toString());
        ITextComponent desc = null;
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"description")) {
            desc = ITextComponent.Serializer.func_150699_a((String)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"description").toString());
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"parent")) {
            this.parent = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"parent"));
        }
        this.name = name;
        this.loc = loc;
        this.desc = desc;
        this.material = material;
        this.slotInfos = new HashMap<EntityEquipmentSlot, JsonSuitSetSlotInfo>();
        this.abilityGenerators = new ArrayList<AbilityGenerator>();
        this.effects = new ArrayList<Effect>();
        this.tab = JsonUtils.func_151219_a((JsonObject)jsonobject, (String)"creative_tab", (String)"addon_packs");
        this.parentAbilities = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"parent_abilities", (boolean)false);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            if (slot == EntityEquipmentSlot.CHEST && !JsonUtils.func_151204_g((JsonObject)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"armor_parts"), (String)slot.toString().toLowerCase())) {
                throw new Exception("Suit sets need a chestplate!");
            }
            if (!JsonUtils.func_151204_g((JsonObject)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"armor_parts"), (String)slot.toString().toLowerCase())) continue;
            JsonSuitSetSlotInfo info = new JsonSuitSetSlotInfo();
            JsonObject armor = JsonUtils.func_152754_s((JsonObject)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"armor_parts"), (String)slot.toString().toLowerCase());
            info.openable = JsonUtils.func_151209_a((JsonObject)armor, (String)"openable", (boolean)false);
            info.glow = JsonUtils.func_151209_a((JsonObject)armor, (String)"glow", (boolean)false);
            info.armor_model_scale = JsonUtils.func_151221_a((JsonObject)armor, (String)"armor_model_scale", (float)0.0f);
            info.name = ITextComponent.Serializer.func_150699_a((String)JsonUtils.func_152754_s((JsonObject)armor, (String)"name").toString());
            info.barColor = EnumAbilityBarColor.fromName(JsonUtils.func_151219_a((JsonObject)armor, (String)"ability_bar_color", (String)""));
            info.textures = new HashMap<String, String>();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)armor, (String)"textures").entrySet()) {
                info.textures.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            info.itemModel = null;
            if (JsonUtils.func_151204_g((JsonObject)armor, (String)"item_texture")) {
                JsonObject item_texture = JsonUtils.func_152754_s((JsonObject)armor, (String)"item_texture");
                if (JsonUtils.func_151204_g((JsonObject)item_texture, (String)"model")) {
                    info.itemModel = JsonSuitSetItemModelType.MODEL;
                    info.itemModelInfo = JsonUtils.func_151200_h((JsonObject)item_texture, (String)"model");
                } else if (JsonUtils.func_151204_g((JsonObject)item_texture, (String)"blockstate")) {
                    info.itemModel = JsonSuitSetItemModelType.BLOCKSTATE;
                    info.itemModelInfo = JsonUtils.func_151200_h((JsonObject)item_texture, (String)"blockstate");
                }
            }
            this.slotInfos.put(slot, info);
        }
        List<Object> list = this.abilityGenerators = JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"abilities") ? Ability.parseAbilityGenerators(jsonobject.get("abilities")) : new ArrayList();
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"effects")) {
            JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"effects");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                this.effects.add(EffectHandler.makeEffect(obj));
            }
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"data")) {
            String s = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"data").toString();
            this.data = JsonToNBT.func_180713_a((String)s);
        }
        return this;
    }

    public static enum JsonSuitSetItemModelType {
        MODEL,
        BLOCKSTATE;

    }

    public static class JsonSuitSetSlotInfo {
        public boolean openable;
        public EnumAbilityBarColor barColor;
        public boolean glow;
        public float armor_model_scale;
        public ITextComponent name;
        public Map<String, String> textures;
        public JsonSuitSetItemModelType itemModel;
        public String itemModelInfo;
    }
}

