/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.abilitybar;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderLayer;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarKeys;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarPos;
import lucraft.mods.lucraftcore.util.abilitybar.EnumAbilityBarColor;
import lucraft.mods.lucraftcore.util.abilitybar.IAbilityBarEntry;
import lucraft.mods.lucraftcore.util.abilitybar.IAbilityBarProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AbilityBarHandler {
    private static final List<IAbilityBarProvider> ENTRIES = new ArrayList<IAbilityBarProvider>();
    public static int INDEX = 0;
    public static final int ENTRY_SHOW_AMOUNT = 5;

    public static void registerProvider(IAbilityBarProvider provider) {
        if (!ENTRIES.contains(provider)) {
            ENTRIES.add(provider);
        }
    }

    public List<IAbilityBarProvider> getProviders() {
        return ImmutableList.copyOf(ENTRIES);
    }

    public static List<IAbilityBarEntry> getActiveEntries() {
        ArrayList<IAbilityBarEntry> list = new ArrayList<IAbilityBarEntry>();
        for (IAbilityBarProvider providers : ENTRIES) {
            for (IAbilityBarEntry entry : providers.getEntries()) {
                if (!entry.isActive()) continue;
                list.add(entry);
            }
        }
        return list;
    }

    public static List<IAbilityBarEntry> getCurrentDisplayedEntries(List<IAbilityBarEntry> active) {
        ArrayList<IAbilityBarEntry> list = new ArrayList<IAbilityBarEntry>();
        if (active.isEmpty()) {
            return list;
        }
        if (INDEX >= active.size()) {
            INDEX = 0;
        } else if (INDEX < 0) {
            INDEX = active.size() - 1;
        }
        list.add(active.get(INDEX));
        int i = INDEX + 1;
        for (int added = 1; list.size() < 5 && added < active.size(); ++added) {
            if (i >= active.size()) {
                i = 0;
            }
            list.add(active.get(i));
            ++i;
        }
        return list;
    }

    public static IAbilityBarEntry getEntryFromKey(int key) {
        if (key > 5) {
            return null;
        }
        List<IAbilityBarEntry> list = AbilityBarHandler.getCurrentDisplayedEntries(AbilityBarHandler.getActiveEntries());
        if (key < 0 || key >= list.size()) {
            return null;
        }
        return list.get(key);
    }

    public static void scroll(boolean up) {
        INDEX = up ? ++INDEX : --INDEX;
    }

    @Mod.EventBusSubscriber(modid="lucraftcore", value={Side.CLIENT})
    public static class Renderer {
        public static ResourceLocation HUD_TEX = new ResourceLocation("lucraftcore", "textures/gui/ability_bar.png");
        public static Minecraft mc = Minecraft.func_71410_x();

        @SubscribeEvent
        public static void onRenderGameOverlay(RenderGameOverlayEvent e) {
            if (e.isCancelable() || LCConfig.abilityBar == AbilityBarPos.DISABLED || e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || Renderer.mc.field_71474_y.field_74330_P || ENTRIES.isEmpty()) {
                return;
            }
            int y = 12;
            List<IAbilityBarEntry> all = AbilityBarHandler.getActiveEntries();
            List<IAbilityBarEntry> current = AbilityBarHandler.getCurrentDisplayedEntries(all);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder bb = tes.func_178180_c();
            boolean names = Renderer.mc.field_71456_v.func_146158_b().func_146241_e();
            ScaledResolution res = e.getResolution();
            boolean right = LCConfig.abilityBar == AbilityBarPos.RIGHT;
            GlStateManager.func_179094_E();
            if (right) {
                GlStateManager.func_179109_b((float)(res.func_78326_a() - 22), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179091_B();
            int k = 0;
            for (IAbilityBarEntry a : current) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                Renderer.mc.field_71446_o.func_110577_a(HUD_TEX);
                EnumAbilityBarColor barColor = a.getColor();
                Renderer.mc.field_71456_v.func_73729_b(0, y, barColor == null ? 0 : barColor.getX(), barColor == null ? 0 : barColor.getY(), 22, 22);
                RenderHelper.func_74520_c();
                GlStateManager.func_179090_x();
                GlStateManager.func_179129_p();
                Renderer.mc.field_71446_o.func_110577_a(SuperpowerRenderLayer.WHITE_TEX);
                GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)0.5f);
                boolean showKey = names || a.showKey() && !names;
                String infoString = names ? a.getDescription() : GameSettings.func_74298_c((int)AbilityBarKeys.KEYS.get(k).func_151463_i());
                ++k;
                int infoLength = Renderer.mc.field_71466_p.func_78256_a(infoString);
                if (showKey) {
                    if (right) {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(0.0, (double)(y + 6), 0.0).func_181675_d();
                        bb.func_181662_b((double)(-2 - infoLength - 6), (double)(y + 6), 0.0).func_181675_d();
                        bb.func_181662_b((double)(-2 - infoLength - 6), (double)(y + 17), 0.0).func_181675_d();
                        bb.func_181662_b(0.0, (double)(y + 17), 0.0).func_181675_d();
                        tes.func_78381_a();
                    } else {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(22.0, (double)(y + 6), 0.0).func_181675_d();
                        bb.func_181662_b((double)(24 + infoLength + 6), (double)(y + 6), 0.0).func_181675_d();
                        bb.func_181662_b((double)(24 + infoLength + 6), (double)(y + 17), 0.0).func_181675_d();
                        bb.func_181662_b(22.0, (double)(y + 17), 0.0).func_181675_d();
                        tes.func_78381_a();
                    }
                }
                if (a.renderCooldown()) {
                    Vec3d color = a.getCooldownColor();
                    float percentage = a.getCooldownPercentage();
                    GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
                    bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                    bb.func_181662_b(4.0, (double)(y + 16), 50.0).func_181675_d();
                    bb.func_181662_b(18.0, (double)(y + 16), 50.0).func_181675_d();
                    bb.func_181662_b(18.0, (double)(y + 18), 50.0).func_181675_d();
                    bb.func_181662_b(4.0, (double)(y + 18), 50.0).func_181675_d();
                    tes.func_78381_a();
                    GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)1.0f);
                    bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                    bb.func_181662_b(4.0, (double)(y + 16), 50.0).func_181675_d();
                    bb.func_181662_b((double)(4.0f + percentage * 14.0f), (double)(y + 16), 50.0).func_181675_d();
                    bb.func_181662_b((double)(4.0f + percentage * 14.0f), (double)(y + 17), 50.0).func_181675_d();
                    bb.func_181662_b(4.0, (double)(y + 17), 50.0).func_181675_d();
                    tes.func_78381_a();
                }
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                a.drawIcon(mc, (Gui)Renderer.mc.field_71456_v, 3, y + 3);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
                if (showKey) {
                    Renderer.mc.field_71456_v.func_73731_b(Renderer.mc.field_71466_p, infoString, right ? -5 - infoLength : 27, y + 8, 0xFEFEFE);
                }
                y += 21;
            }
            if (all.size() > 5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179090_x();
                GlStateManager.func_179129_p();
                Renderer.mc.field_71446_o.func_110577_a(SuperpowerRenderLayer.WHITE_TEX);
                GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)0.5f);
                boolean showUp = AbilityBarKeys.UP.func_151463_i() != 0 || names;
                boolean showDown = AbilityBarKeys.DOWN.func_151463_i() != 0 || names;
                String key = AbilityBarKeys.UP.func_151463_i() == 0 && LCConfig.abilityBarScrolling ? "SHIFT + SCROLL" : GameSettings.func_74298_c((int)AbilityBarKeys.UP.func_151463_i());
                String key2 = AbilityBarKeys.DOWN.func_151463_i() == 0 && LCConfig.abilityBarScrolling ? "SHIFT + SCROLL" : GameSettings.func_74298_c((int)AbilityBarKeys.DOWN.func_151463_i());
                int infoLength = Renderer.mc.field_71466_p.func_78256_a(key);
                int infoLength2 = Renderer.mc.field_71466_p.func_78256_a(key2);
                if (right) {
                    if (showUp) {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(11.0, 2.0, -100.0).func_181675_d();
                        bb.func_181662_b((double)(2 - infoLength - 6), 2.0, -100.0).func_181675_d();
                        bb.func_181662_b((double)(2 - infoLength - 6), 11.0, -100.0).func_181675_d();
                        bb.func_181662_b(4.0, 11.0, -100.0).func_181675_d();
                        tes.func_78381_a();
                    }
                    if (showDown) {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(4.0, (double)(y + 2), -100.0).func_181675_d();
                        bb.func_181662_b((double)(2 - infoLength2 - 6), (double)(y + 2), -100.0).func_181675_d();
                        bb.func_181662_b((double)(2 - infoLength2 - 6), (double)(y + 11), -100.0).func_181675_d();
                        bb.func_181662_b(11.0, (double)(y + 11), -100.0).func_181675_d();
                        tes.func_78381_a();
                    }
                } else {
                    if (showUp) {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(11.0, 2.0, -100.0).func_181675_d();
                        bb.func_181662_b((double)(20 + infoLength + 6), 2.0, -100.0).func_181675_d();
                        bb.func_181662_b((double)(20 + infoLength + 6), 11.0, -100.0).func_181675_d();
                        bb.func_181662_b(18.0, 11.0, -100.0).func_181675_d();
                        tes.func_78381_a();
                    }
                    if (showDown) {
                        bb.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                        bb.func_181662_b(18.0, (double)(y + 2), -100.0).func_181675_d();
                        bb.func_181662_b((double)(20 + infoLength2 + 6), (double)(y + 2), -100.0).func_181675_d();
                        bb.func_181662_b((double)(20 + infoLength2 + 6), (double)(y + 11), -100.0).func_181675_d();
                        bb.func_181662_b(11.0, (double)(y + 11), -100.0).func_181675_d();
                        tes.func_78381_a();
                    }
                }
                GlStateManager.func_179098_w();
                if (showUp) {
                    Renderer.mc.field_71456_v.func_73731_b(Renderer.mc.field_71466_p, key, right ? -1 - infoLength : 23, 3, 0xFEFEFE);
                }
                if (showDown) {
                    Renderer.mc.field_71456_v.func_73731_b(Renderer.mc.field_71466_p, key2, right ? -1 - infoLength2 : 23, y + 3, 0xFEFEFE);
                }
                Renderer.mc.field_71446_o.func_110577_a(HUD_TEX);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Renderer.mc.field_71456_v.func_73729_b(4, 2, 40, 0, 14, 9);
                Renderer.mc.field_71456_v.func_73729_b(4, y + 2, 54, 0, 14, 9);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

