/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.energy;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItem
implements IEnergyStorage {
    public ItemStack stack;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorageItem(ItemStack stack, int capacity) {
        this(stack, capacity, capacity, capacity, 0);
    }

    public EnergyStorageItem(ItemStack stack, int capacity, int maxTransfer) {
        this(stack, capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorageItem(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        this(stack, capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorageItem(ItemStack stack, int capacity, int maxReceive, int maxExtract, int energy) {
        this.stack = stack;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            this.setEnergyStored(Math.max(0, Math.min(capacity, energy)));
        }
    }

    public void setEnergyStored(int energy) {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        int i = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
        this.stack.func_77978_p().func_74768_a("Energy", i);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stack != null && this.stack.func_77942_o() ? this.stack.func_77978_p().func_74762_e("Energy") : 0;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }
}

