/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.gui;

import java.util.HashMap;
import lucraft.mods.lucraftcore.LucraftCore;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LCGuiHandler
implements IGuiHandler {
    private static HashMap<Integer, GuiHandlerEntry> guis = new HashMap();

    public static void registerGuiHandlerEntry(int id, GuiHandlerEntry entry) {
        if (guis.containsKey(id)) {
            LucraftCore.LOGGER.error("That gui handler entry id is already taken!");
        } else {
            guis.put(id, entry);
        }
    }

    public static void openGui(EntityPlayer player, int id) {
        if (!guis.containsKey(id)) {
            LucraftCore.LOGGER.error("There is no gui registered with the id '" + id + "'!");
        } else {
            player.openGui((Object)LucraftCore.INSTANCE, id, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (guis.containsKey(ID)) {
            return guis.get(ID).getServerContainer(player, world, x, y, z);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (guis.containsKey(ID)) {
            return guis.get(ID).getClientGui(player, world, x, y, z);
        }
        return null;
    }

    public static abstract class GuiHandlerEntry {
        @SideOnly(value=Side.CLIENT)
        public abstract GuiScreen getClientGui(EntityPlayer var1, World var2, int var3, int var4, int var5);

        public abstract Container getServerContainer(EntityPlayer var1, World var2, int var3, int var4, int var5);
    }
}

