/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.items;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarHandler;
import lucraft.mods.lucraftcore.util.abilitybar.EnumAbilityBarColor;
import lucraft.mods.lucraftcore.util.abilitybar.IAbilityBarEntry;
import lucraft.mods.lucraftcore.util.abilitybar.IAbilityBarProvider;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpenableArmor {
    @SideOnly(value=Side.CLIENT)
    public static void init() {
        AbilityBarHandler.registerProvider(new OpenableArmorBarProvider());
    }

    @SideOnly(value=Side.CLIENT)
    public static class OpenableArmorBarEntry
    implements IAbilityBarEntry {
        public ItemStack item;
        public EntityEquipmentSlot slot;

        public OpenableArmorBarEntry(ItemStack item, EntityEquipmentSlot slot) {
            this.item = item;
            this.slot = slot;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void onButtonPress() {
            LCPacketDispatcher.sendToServer(new MessageToggleArmor(this.slot));
        }

        @Override
        public void onButtonRelease() {
        }

        @Override
        public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
            float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
            mc.func_175599_af().field_77023_b = -100.5f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            mc.func_175599_af().func_175042_a(this.item, 0, 0);
            if (((IOpenableArmor)this.item.func_77973_b()).isArmorOpen((Entity)mc.field_71439_g, this.item)) {
                mc.field_71446_o.func_110577_a(AbilityBarHandler.Renderer.HUD_TEX);
                mc.field_71456_v.func_73729_b(12, 12, 24, 0, 6, 6);
            }
            GlStateManager.func_179121_F();
            mc.func_175599_af().field_77023_b = zLevel;
        }

        @Override
        public String getDescription() {
            return StringHelper.translateToLocal("lucraftcore.info.openarmor").replace("%s", this.item.func_82833_r());
        }

        @Override
        public boolean renderCooldown() {
            return false;
        }

        @Override
        public float getCooldownPercentage() {
            return 0.0f;
        }

        @Override
        public EnumAbilityBarColor getColor() {
            IOpenableArmor armor = (IOpenableArmor)this.item.func_77973_b();
            return armor.getAbilityBarColor((Entity)Minecraft.func_71410_x().field_71439_g, this.item, armor.isArmorOpen((Entity)Minecraft.func_71410_x().field_71439_g, this.item));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class OpenableArmorBarProvider
    implements IAbilityBarProvider {
        @Override
        public List<IAbilityBarEntry> getEntries() {
            ArrayList<IAbilityBarEntry> entries = new ArrayList<IAbilityBarEntry>();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack;
                if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = player.func_184582_a(slot)).func_190926_b() || !(stack.func_77973_b() instanceof IOpenableArmor) || !((IOpenableArmor)stack.func_77973_b()).canBeOpened((Entity)player, stack)) continue;
                entries.add(new OpenableArmorBarEntry(stack, slot));
            }
            return entries;
        }
    }

    public static class MessageToggleArmor
    implements IMessage {
        public EntityEquipmentSlot slot;

        public MessageToggleArmor() {
        }

        public MessageToggleArmor(EntityEquipmentSlot slot) {
            this.slot = slot;
        }

        public void fromBytes(ByteBuf buf) {
            this.slot = EntityEquipmentSlot.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.slot.ordinal());
        }

        public static class Handler
        extends AbstractServerMessageHandler<MessageToggleArmor> {
            @Override
            public IMessage handleServerMessage(final EntityPlayer player, final MessageToggleArmor message, MessageContext ctx) {
                LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ItemStack stack = player.func_184582_a(message.slot);
                        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IOpenableArmor) {
                            IOpenableArmor armor;
                            boolean isOpen = (armor = (IOpenableArmor)stack.func_77973_b()).isArmorOpen((Entity)player, stack);
                            armor.setArmorOpen((Entity)player, stack, !isOpen);
                            armor.onArmorToggled((Entity)player, stack, !isOpen);
                        }
                    }
                });
                return null;
            }
        }
    }

    public static interface IOpenableArmor {
        public boolean canBeOpened(Entity var1, ItemStack var2);

        public void setArmorOpen(Entity var1, ItemStack var2, boolean var3);

        public boolean isArmorOpen(Entity var1, ItemStack var2);

        public void onArmorToggled(Entity var1, ItemStack var2, boolean var3);

        default public EnumAbilityBarColor getAbilityBarColor(Entity entity, ItemStack stack, boolean open) {
            return null;
        }
    }
}

