/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.util.energy.EnergyStorageExt;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFurnaceGenerator
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? TileEntityFurnace.func_145954_b((ItemStack)stack) : stack.hasCapability(CapabilityEnergy.ENERGY, null);
        }
    };
    private String customName;
    public EnergyStorageExt energyStorage = new EnergyStorageExt(100000, 1000);
    public int fuel;
    public int totalFuel;

    public void func_73660_a() {
        IEnergyStorage energyStorage;
        boolean update = false;
        ItemStack fuel = this.inventory.getStackInSlot(0);
        ItemStack energyItem = this.inventory.getStackInSlot(1);
        if (this.fuel <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() && !fuel.func_190926_b() && TileEntityFurnace.func_145954_b((ItemStack)fuel)) {
            this.totalFuel = this.fuel = TileEntityFurnace.func_145952_a((ItemStack)fuel);
            if (fuel.func_77973_b() == Items.field_151129_at) {
                this.inventory.setStackInSlot(0, new ItemStack(Items.field_151133_ar));
            } else {
                fuel.func_190918_g(1);
            }
        }
        if (this.fuel > 0) {
            --this.fuel;
            this.energyStorage.receiveEnergy(10, false);
        }
        if (!energyItem.func_190926_b() && energyItem.hasCapability(CapabilityEnergy.ENERGY, null) && this.energyStorage.getEnergyStored() > 0 && (energyStorage = (IEnergyStorage)energyItem.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() < energyStorage.getMaxEnergyStored()) {
            int i = 1000;
            int maxOutput = this.energyStorage.extractEnergy(i, true);
            int maxInput = energyStorage.receiveEnergy(i, true);
            int energy = Math.min(maxInput, maxOutput);
            int energy2 = Math.min(maxInput, maxOutput);
            if (energy > 0) {
                energyStorage.receiveEnergy(energy, false);
                this.energyStorage.extractEnergy(energy2, false);
            }
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IEnergyStorage energyStorage2;
                TileEntity tileEntity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177971_a(facing.func_176730_m()));
                if (tileEntity == null || tileEntity instanceof TileEntityFurnaceGenerator || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || (energyStorage2 = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).getEnergyStored() >= energyStorage2.getMaxEnergyStored()) continue;
                int i = 1000;
                int maxOutput = this.energyStorage.extractEnergy(i, true);
                int maxInput = energyStorage2.receiveEnergy(i, true);
                int energy = Math.min(maxInput, maxOutput);
                int energy2 = Math.min(maxInput, maxOutput);
                if (energy <= 0) continue;
                energyStorage2.receiveEnergy(energy, false);
                this.energyStorage.extractEnergy(energy2, false);
            }
        }
        if (this.energyStorage.update) {
            this.energyStorage.update = false;
            update = true;
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void dropAllItems(World worldIn, BlockPos pos) {
        IItemHandlerModifiable handler = (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null && !this.customName.isEmpty() ? new TextComponentString(this.customName) : new TextComponentTranslation("tile.furnace_generator.name", new Object[0]);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.energyStorage.deserializeNBT(compound);
        this.fuel = compound.func_74762_e("Fuel");
        this.totalFuel = compound.func_74762_e("TotalFuel");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        compound.func_74768_a("Fuel", this.fuel);
        compound.func_74768_a("TotalFuel", this.totalFuel);
        if (this.customName != null && !this.customName.isEmpty()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

