/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.items;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.util.items.ExtendedTooltip;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import lucraft.mods.lucraftcore.utilities.recipes.InstructionRecipe;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ItemInstruction
extends ItemBase
implements ExtendedTooltip.IExtendedItemToolTip {
    public ItemInstruction(String name) {
        super(name);
        this.func_77637_a(LucraftCore.CREATIVE_TAB);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (InstructionRecipe recipes : InstructionRecipe.getInstructionRecipes()) {
            ItemStack stack = new ItemStack((Item)this);
            ItemInstruction.setInstructionRecipes(stack, recipes);
            items.add((Object)stack);
        }
        ItemStack stack = new ItemStack((Item)this);
        stack.func_151001_c("All recipes");
        ItemInstruction.setInstructionRecipes(stack, InstructionRecipe.getInstructionRecipes().toArray(new InstructionRecipe[InstructionRecipe.getInstructionRecipes().size()]));
        items.add((Object)stack);
    }

    public static void setInstructionRecipes(ItemStack stack, InstructionRecipe ... instruction) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInstruction)) {
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < instruction.length; ++i) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagString(instruction[i].getRegistryName().toString()));
        }
        nbt.func_74782_a("Recipes", (NBTBase)nbttaglist);
        stack.func_77982_d(nbt);
    }

    public static InstructionRecipe[] getInstructionRecipes(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInstruction) || !stack.func_77942_o()) {
            return null;
        }
        NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("Recipes", 8);
        ArrayList<InstructionRecipe> list = new ArrayList<InstructionRecipe>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            if (!InstructionRecipe.getInstructionRecipesMap().containsKey(new ResourceLocation(nbttaglist.func_150307_f(i)))) continue;
            list.add(InstructionRecipe.getInstructionRecipesMap().get(new ResourceLocation(nbttaglist.func_150307_f(i))));
        }
        InstructionRecipe[] instructions = new InstructionRecipe[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            instructions[i] = (InstructionRecipe)list.get(i);
        }
        return instructions;
    }

    @Override
    public boolean shouldShiftTooltipAppear(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    public List<String> getShiftToolTip(ItemStack stack, EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77942_o()) {
            for (InstructionRecipe recipe : ItemInstruction.getInstructionRecipes(stack)) {
                if (recipe == null) continue;
                list.add(TextFormatting.BOLD + recipe.getOutput().func_82833_r() + ":");
                for (ItemStack s : recipe.getRequirements()) {
                    list.add(" - " + s.func_82833_r());
                }
            }
        }
        return list;
    }

    @Override
    public boolean shouldCtrlTooltipAppear(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public List<String> getCtrlToolTip(ItemStack stack, EntityPlayer player) {
        return null;
    }
}

