/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei.boiler;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.utilities.recipes.BoilerRecipeHandler;
import lucraft.mods.lucraftcore.utilities.recipes.IBoilerRecipe;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class BoilerRecipeWrapper
implements IRecipeWrapper {
    private final IJeiHelpers jeiHelpers;
    public IBoilerRecipe recipe;

    public BoilerRecipeWrapper(IJeiHelpers jeiHelpers, IBoilerRecipe recipe) {
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        FluidStack recipeInput = this.recipe.getInputFluid();
        FluidStack recipeOutput = this.recipe.getResult();
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        NonNullList inputs = NonNullList.func_191196_a();
        for (Ingredient ingredient : this.recipe.getIngredients()) {
            inputs.add((Object)ingredient);
        }
        List inputLists = stackHelper.expandRecipeItemStackInputs((List)inputs);
        ingredients.setInput(FluidStack.class, (Object)recipeInput);
        ingredients.setInputLists(ItemStack.class, inputLists);
        ingredients.setOutput(FluidStack.class, (Object)recipeOutput);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = StringHelper.translateToLocal("lucraftcore.info.energy_display", this.recipe.getRequiredEnergy(), "FE");
        minecraft.field_71466_p.func_78276_b(s, 67 - minecraft.field_71466_p.func_78256_a(s) / 2, recipeHeight - 6, 0x404040);
    }

    public static List<BoilerRecipeWrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<BoilerRecipeWrapper> recipes = new ArrayList<BoilerRecipeWrapper>();
        for (IBoilerRecipe recipe : BoilerRecipeHandler.getRecipes()) {
            recipes.add(new BoilerRecipeWrapper(jeiHelpers, recipe));
        }
        return recipes;
    }
}

