/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.lucraftcore.utilities.recipes.InstructionRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncInstructionRecipe
implements IMessage {
    public InstructionRecipe recipe;

    public MessageSyncInstructionRecipe() {
    }

    public MessageSyncInstructionRecipe(InstructionRecipe recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        ResourceLocation loc = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        ItemStack output = ByteBufUtils.readItemStack((ByteBuf)buf);
        int amount = buf.readInt();
        ItemStack[] requirements = new ItemStack[amount];
        for (int i = 0; i < amount; ++i) {
            requirements[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.recipe = new InstructionRecipe(output, requirements).setRegistryName(loc);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.recipe.getRegistryName().toString());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.recipe.getOutput());
        buf.writeInt(this.recipe.getRequirements().size());
        for (int i = 0; i < this.recipe.getRequirements().size(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.recipe.getRequirements().get(i));
        }
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncInstructionRecipe> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, final MessageSyncInstructionRecipe message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    InstructionRecipe.getInstructionRecipesMap().put(message.recipe.getRegistryName(), message.recipe);
                }
            });
            return null;
        }
    }
}

