/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.recipes;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.addonpacks.AddonPackRecipeReader;
import lucraft.mods.lucraftcore.util.fluids.LCFluidUtil;
import lucraft.mods.lucraftcore.utilities.recipes.BoilerRecipe;
import lucraft.mods.lucraftcore.utilities.recipes.IBoilerRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class BoilerRecipeHandler {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static int id = 0;
    private static RegistryNamespaced<ResourceLocation, IBoilerRecipe> RECIPES = new RegistryNamespaced();
    public static Map<ResourceLocation, JsonObject> cachedRecipes = new HashMap<ResourceLocation, JsonObject>();
    public static Map<String, AddonPackRecipeReader.JsonContextExt> cachedContexts = new HashMap<String, AddonPackRecipeReader.JsonContextExt>();
    public static Map<String, JsonObject[]> cachedJsonContexts = new HashMap<String, JsonObject[]>();

    public static void registerRecipe(IBoilerRecipe recipe) {
        if (recipe == null) {
            LucraftCore.LOGGER.error("Tried to register null boiler recipe!");
            return;
        }
        if (recipe.getRegistryName() == null) {
            LucraftCore.LOGGER.error("Tried to register boiler recipe without registry name!");
            return;
        }
        if (RECIPES.func_148741_d((Object)recipe.getRegistryName())) {
            LucraftCore.LOGGER.error("A boiler recipe with the registry name '" + recipe.getRegistryName().toString() + "' already exists!");
            return;
        }
        RECIPES.func_177775_a(id++, (Object)recipe.getRegistryName(), (Object)recipe);
    }

    public static IBoilerRecipe getRecipe(ResourceLocation resourceLocation) {
        return (IBoilerRecipe)RECIPES.func_82594_a((Object)resourceLocation);
    }

    public static List<IBoilerRecipe> getRecipes() {
        return ImmutableList.copyOf(RECIPES);
    }

    public static IBoilerRecipe findBoilerRecipe(List<ItemStack> items, FluidStack fluidStack, int energy) {
        for (IBoilerRecipe recipe : BoilerRecipeHandler.getRecipes()) {
            if (!BoilerRecipeHandler.matches(recipe, items, fluidStack, energy)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(IBoilerRecipe recipe, List<ItemStack> items, FluidStack fluidStack, int energy) {
        if (energy < recipe.getRequiredEnergy()) {
            return false;
        }
        if (recipe.getInputFluid() != null) {
            if (fluidStack == null) {
                return false;
            }
            if (recipe.getInputFluid().getFluid() != fluidStack.getFluid()) {
                return false;
            }
            if (fluidStack.amount < recipe.getInputFluid().amount) {
                return false;
            }
        }
        if (items == null || items.size() <= 0) {
            return false;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.addAll(items);
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            for (ItemStack stack : items) {
                if (ingredientList.contains(ingredient) || !list.contains(stack) || !ingredient.apply(stack)) continue;
                list.remove(stack);
                ingredientList.add(ingredient);
            }
        }
        return ingredientList.size() == recipe.getIngredients().length && list.size() == 0;
    }

    public static IBoilerRecipe parseFromJson(JsonObject json, JsonContext context, ResourceLocation loc) {
        JsonArray jsonArray;
        FluidStack input = JsonUtils.func_151204_g((JsonObject)json, (String)"input_fluid") ? LCFluidUtil.parseFromJson(JsonUtils.func_152754_s((JsonObject)json, (String)"input_fluid")) : null;
        FluidStack output = LCFluidUtil.parseFromJson(JsonUtils.func_152754_s((JsonObject)json, (String)"result"));
        int energy = JsonUtils.func_151208_a((JsonObject)json, (String)"energy", (int)0);
        if (output == null) {
            throw new RuntimeException("The result fluid can not be null!");
        }
        JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients");
        Ingredient[] ingredients = new Ingredient[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            ingredients[i] = CraftingHelper.getIngredient((JsonElement)array.get(i), (JsonContext)context);
            if (ingredients[i] != null && ingredients[i].func_193365_a().length > 0) continue;
            return null;
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"conditions") && !CraftingHelper.processConditions((JsonArray)(jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)"conditions")), (JsonContext)context)) {
            return null;
        }
        return new BoilerRecipe(output, energy, input, ingredients).setRegistryName(loc);
    }

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getDirectory().equals("boiler_recipes") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
            if (e.getFileName().endsWith("_constants.json")) {
                JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject[].class);
                cachedJsonContexts.put(e.getResourceLocation().func_110624_b(), json);
            } else {
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject.class);
                cachedRecipes.put(e.getResourceLocation(), json);
            }
            IOUtils.closeQuietly((Reader)bufferedreader);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> e) {
        AddonPackRecipeReader.JsonContextExt context;
        for (String mods : cachedJsonContexts.keySet()) {
            context = new AddonPackRecipeReader.JsonContextExt(mods);
            context.loadConstants(cachedJsonContexts.get(mods));
            cachedContexts.put(mods, context);
        }
        for (ResourceLocation loc : cachedRecipes.keySet()) {
            try {
                context = cachedContexts.containsKey(loc.func_110624_b()) ? cachedContexts.get(loc.func_110624_b()) : new AddonPackRecipeReader.JsonContextExt(loc.func_110624_b());
                IBoilerRecipe recipe = BoilerRecipeHandler.parseFromJson(cachedRecipes.get(loc), context, loc);
                if (recipe != null) {
                    BoilerRecipeHandler.registerRecipe(recipe);
                } else {
                    LucraftCore.LOGGER.error("Wasn't able to register boiler recipe '" + loc.toString() + "'!");
                }
                cachedContexts.put(loc.func_110624_b(), context);
            }
            catch (Exception exception) {
                LucraftCore.LOGGER.error("Wasn't able to register boiler recipe '" + loc.toString() + "': " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        cachedJsonContexts.clear();
        cachedContexts.clear();
        cachedRecipes.clear();
    }
}

