/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.recipes;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.addonpacks.AddonPackRecipeReader;
import lucraft.mods.lucraftcore.util.fluids.LCFluidUtil;
import lucraft.mods.lucraftcore.utilities.recipes.ExtractorRecipe;
import lucraft.mods.lucraftcore.utilities.recipes.IExtractorRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class ExtractorRecipeHandler {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static int id = 0;
    private static RegistryNamespaced<ResourceLocation, IExtractorRecipe> RECIPES = new RegistryNamespaced();
    public static Map<ResourceLocation, JsonObject> cachedRecipes = new HashMap<ResourceLocation, JsonObject>();
    public static Map<String, AddonPackRecipeReader.JsonContextExt> cachedContexts = new HashMap<String, AddonPackRecipeReader.JsonContextExt>();
    public static Map<String, JsonObject[]> cachedJsonContexts = new HashMap<String, JsonObject[]>();

    public static void registerRecipe(IExtractorRecipe recipe) {
        if (recipe == null) {
            LucraftCore.LOGGER.error("Tried to register null extractor recipe!");
            return;
        }
        if (recipe.getRegistryName() == null) {
            LucraftCore.LOGGER.error("Tried to register extractor recipe without registry name!");
            return;
        }
        if (RECIPES.func_148741_d((Object)recipe.getRegistryName())) {
            LucraftCore.LOGGER.error("An extractor recipe with the registry name '" + recipe.getRegistryName().toString() + "' already exists!");
            return;
        }
        RECIPES.func_177775_a(id++, (Object)recipe.getRegistryName(), (Object)recipe);
    }

    public static IExtractorRecipe getRecipe(ResourceLocation resourceLocation) {
        return (IExtractorRecipe)RECIPES.func_82594_a((Object)resourceLocation);
    }

    public static List<IExtractorRecipe> getRecipes() {
        return ImmutableList.copyOf(RECIPES);
    }

    public static IExtractorRecipe findExtractorRecipe(ItemStack input, ItemStack inputContainer, FluidStack inputFluid, int energy) {
        for (IExtractorRecipe recipe : ExtractorRecipeHandler.getRecipes()) {
            if (!ExtractorRecipeHandler.matches(recipe, input, inputContainer, inputFluid, energy)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(IExtractorRecipe recipe, ItemStack input, ItemStack inputContainer, FluidStack inputFluid, int energy) {
        if (energy < recipe.getRequiredEnergy()) {
            return false;
        }
        if (recipe.getInputFluid() != null) {
            if (inputFluid == null) {
                return false;
            }
            if (recipe.getInputFluid().getFluid() != inputFluid.getFluid()) {
                return false;
            }
            if (inputFluid.amount < recipe.getInputFluid().amount) {
                return false;
            }
        }
        if (recipe.getInputContainer() != null && !recipe.getInputContainer().apply(inputContainer)) {
            return false;
        }
        return recipe.getInput().apply(input) && input.func_190916_E() >= recipe.getInputAmount();
    }

    public static IExtractorRecipe parseFromJson(JsonObject json, JsonContext context, ResourceLocation loc) {
        JsonArray jsonArray;
        FluidStack inputFluid = JsonUtils.func_151204_g((JsonObject)json, (String)"input_fluid") ? LCFluidUtil.parseFromJson(JsonUtils.func_152754_s((JsonObject)json, (String)"input_fluid")) : null;
        int energy = JsonUtils.func_151208_a((JsonObject)json, (String)"energy", (int)0);
        Ingredient input = CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)json, (String)"input"), (JsonContext)context);
        int inputAmount = MathHelper.func_76125_a((int)JsonUtils.func_151208_a((JsonObject)json, (String)"input_amount", (int)1), (int)0, (int)64);
        Ingredient inputContainer = JsonUtils.func_151204_g((JsonObject)json, (String)"input_container") ? CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)json, (String)"input_container"), (JsonContext)context) : null;
        JsonObject outputJson = JsonUtils.func_152754_s((JsonObject)json, (String)"outputs");
        JsonObject primaryOutput = JsonUtils.func_152754_s((JsonObject)outputJson, (String)"primary");
        ItemStack primaryResult = CraftingHelper.getItemStack((JsonObject)primaryOutput, (JsonContext)context);
        float primaryChance = MathHelper.func_76131_a((float)JsonUtils.func_151221_a((JsonObject)primaryOutput, (String)"chance", (float)1.0f), (float)0.0f, (float)1.0f);
        ItemStack secondaryResult = ItemStack.field_190927_a;
        float secondaryChance = 0.0f;
        if (JsonUtils.func_151204_g((JsonObject)outputJson, (String)"secondary")) {
            JsonObject secondaryOutput = JsonUtils.func_152754_s((JsonObject)outputJson, (String)"secondary");
            secondaryResult = CraftingHelper.getItemStack((JsonObject)secondaryOutput, (JsonContext)context);
            secondaryChance = MathHelper.func_76131_a((float)JsonUtils.func_151221_a((JsonObject)secondaryOutput, (String)"chance", (float)1.0f), (float)0.0f, (float)1.0f);
        }
        if (input == null || input.func_193365_a().length <= 0) {
            return null;
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"conditions") && !CraftingHelper.processConditions((JsonArray)(jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)"conditions")), (JsonContext)context)) {
            return null;
        }
        return new ExtractorRecipe(input, inputAmount, inputContainer, inputFluid, primaryResult, primaryChance, secondaryResult, secondaryChance, energy).setRegistryName(loc);
    }

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getDirectory().equals("extractor_recipes") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
            if (e.getFileName().endsWith("_constants.json")) {
                JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject[].class);
                cachedJsonContexts.put(e.getResourceLocation().func_110624_b(), json);
            } else {
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject.class);
                cachedRecipes.put(e.getResourceLocation(), json);
            }
            IOUtils.closeQuietly((Reader)bufferedreader);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> e) {
        AddonPackRecipeReader.JsonContextExt context;
        for (String mods : cachedJsonContexts.keySet()) {
            context = new AddonPackRecipeReader.JsonContextExt(mods);
            context.loadConstants(cachedJsonContexts.get(mods));
            cachedContexts.put(mods, context);
        }
        for (ResourceLocation loc : cachedRecipes.keySet()) {
            try {
                context = cachedContexts.containsKey(loc.func_110624_b()) ? cachedContexts.get(loc.func_110624_b()) : new AddonPackRecipeReader.JsonContextExt(loc.func_110624_b());
                IExtractorRecipe recipe = ExtractorRecipeHandler.parseFromJson(cachedRecipes.get(loc), context, loc);
                if (recipe != null) {
                    ExtractorRecipeHandler.registerRecipe(recipe);
                } else {
                    LucraftCore.LOGGER.error("Wasn't able to register extractor recipe '" + loc.toString() + "'!");
                }
                cachedContexts.put(loc.func_110624_b(), context);
            }
            catch (Exception exception) {
                LucraftCore.LOGGER.error("Wasn't able to register extractor recipe '" + loc.toString() + "': " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        cachedJsonContexts.clear();
        cachedContexts.clear();
        cachedRecipes.clear();
    }
}

