/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.utilities.network.MessageClearInstructionRecipes;
import lucraft.mods.lucraftcore.utilities.network.MessageSyncInstructionRecipe;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class InstructionRecipe {
    private static Map<ResourceLocation, InstructionRecipe> RECIPES = new HashMap<ResourceLocation, InstructionRecipe>();
    private static Map<ResourceLocation, InstructionRecipe> OVERRIDEN = new HashMap<ResourceLocation, InstructionRecipe>();
    protected ItemStack output;
    protected List<ItemStack> requirements;
    protected ResourceLocation registryName;

    public static void registerInstructionRecipe(InstructionRecipe recipe) {
        if (recipe.getRegistryName() == null) {
            LucraftCore.LOGGER.error("Instruction recipe is missing a registry name!");
            return;
        }
        if (RECIPES.containsKey(recipe.getRegistryName())) {
            LucraftCore.LOGGER.error("There is already an instruction recipe with the registry name " + recipe.getRegistryName().toString() + "!");
            return;
        }
        RECIPES.put(recipe.getRegistryName(), recipe);
        OVERRIDEN.put(recipe.getRegistryName(), recipe);
    }

    public static Map<ResourceLocation, InstructionRecipe> getInstructionRecipesMap() {
        return OVERRIDEN;
    }

    public static List<InstructionRecipe> getInstructionRecipes() {
        ArrayList<InstructionRecipe> list = new ArrayList<InstructionRecipe>();
        for (InstructionRecipe recipes : OVERRIDEN.values()) {
            list.add(recipes);
        }
        return list;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.field_70170_p.field_72995_K && e.player instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageClearInstructionRecipes(), (EntityPlayerMP)e.player);
            for (InstructionRecipe recipes : RECIPES.values()) {
                LCPacketDispatcher.sendTo(new MessageSyncInstructionRecipe(recipes), (EntityPlayerMP)e.player);
            }
        }
    }

    public InstructionRecipe(ItemStack output, ItemStack ... requirements) {
        this.output = output;
        this.requirements = Arrays.asList(requirements);
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public List<ItemStack> getRequirements() {
        return this.requirements;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InstructionRecipe)) {
            return false;
        }
        InstructionRecipe r = (InstructionRecipe)obj;
        return ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)r.getOutput(), (ItemStack)this.getOutput()) && r.getRequirements().equals(this.getRequirements());
    }

    public InstructionRecipe setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public InstructionRecipe setRegistryName(String modid, String name) {
        return this.setRegistryName(new ResourceLocation(modid, name));
    }

    public InstructionRecipe setRegistryName(String name) {
        return this.setRegistryName(new ResourceLocation(name));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

