/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.abilities;

import java.util.UUID;
import lucraft.mods.lucraftcore.abilities.AbilityConstant;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public abstract class AbilityAttributeModifier
extends AbilityConstant {
    protected float factor;
    protected int operation;
    protected UUID uuid;

    public AbilityAttributeModifier(EntityPlayer player, UUID uuid, float factor, int operation) {
        super(player);
        this.factor = factor;
        this.operation = operation;
        this.uuid = uuid;
    }

    @Override
    public String getDisplayDescription() {
        return super.getDisplayDescription() + "\n \n" + TextFormatting.BLUE + (this.getOperation() == 0 ? "+" : "*") + this.getFactor();
    }

    public abstract IAttribute getAttribute();

    public UUID getModifierUUID() {
        return this.uuid;
    }

    public float getFactor() {
        return this.factor;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public void updateTick() {
        if (this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) != null && (this.player.func_110148_a(this.getAttribute()).func_111127_a(this.getModifierUUID()).func_111164_d() != (double)this.getFactor() || this.player.func_110148_a(this.getAttribute()).func_111127_a(this.getModifierUUID()).func_111169_c() != this.getOperation())) {
            this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_188479_b(this.getModifierUUID());
        }
        if (this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) == null) {
            AttributeModifier modifier = new AttributeModifier(this.getModifierUUID(), this.getUnlocalizedName(), (double)this.getFactor(), this.getOperation()).func_111168_a(false);
            this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_111121_a(modifier);
        }
    }

    @Override
    public void lastTick() {
        if (this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) != null) {
            this.player.func_110140_aT().func_111151_a(this.getAttribute()).func_188479_b(this.getModifierUUID());
        }
    }

    @Override
    public boolean showInAbilityBar() {
        return false;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.factor = nbt.func_74760_g("Factor");
        this.operation = nbt.func_74762_e("Operation");
        this.uuid = UUID.fromString(nbt.func_74779_i("UUID"));
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74776_a("Factor", this.factor);
        nbt.func_74768_a("Operation", this.operation);
        nbt.func_74778_a("UUID", this.uuid.toString());
        return nbt;
    }
}

