/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.abilities;

import lucraft.mods.lucraftcore.abilities.AbilityConstant;
import lucraft.mods.lucraftcore.util.LCRenderHelper;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityDamageResistance
extends AbilityConstant {
    public float multiplier;

    public AbilityDamageResistance(EntityPlayer player) {
        this(player, 0.0f);
    }

    public AbilityDamageResistance(EntityPlayer player, float multiplier) {
        super(player);
        this.multiplier = multiplier;
    }

    @Override
    public String getDisplayDescription() {
        float f = (1.0f - this.multiplier) * 100.0f;
        return super.getDisplayDescription() + "\n \n" + TextFormatting.BLUE + -LucraftCoreUtil.round(f, 2) + "% " + LucraftCoreUtil.translateToLocal("lucraftcore.info.damage");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 5);
    }

    @Override
    public boolean showInAbilityBar() {
        return false;
    }

    @Override
    public void updateTick() {
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void onPlayerHurt(LivingHurtEvent e) {
        e.setAmount(e.getAmount() * this.getMultiplier());
        super.onHurt(e);
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.multiplier = nbt.func_74760_g("Multiplier");
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74776_a("Multiplier", this.multiplier);
        return nbt;
    }
}

