/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.access;

import lucraft.mods.lucraftcore.access.LucraftForgeLoading;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LucraftClassTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            return LucraftClassTransformer.patchClassASMRendererEntityLiving(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.client.model.ModelBiped")) {
            return this.patchClassASMModelBiped(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.server.MinecraftServer")) {
            return this.patchClassASMMinecraftServer(name, classBytes, false);
        }
        if (transformedName.equals("paulscode.sound.SoundSystem")) {
            return this.patchClassASMSoundSystem(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            return this.patchClassEntityLivingBase(name, classBytes, false);
        }
        if (transformedName.equals("net.minecraft.client.renderer.ItemRenderer")) {
            return this.patchClassRenderItem(name, classBytes, false);
        }
        return classBytes;
    }

    private byte[] patchClassRenderItem(String name, byte[] bytes, boolean obf) {
        String renderMethod = LucraftForgeLoading.runtimeObfuscationEnabled ? "renderItemSide" : "func_187462_a";
        String renderDesc = "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;Z)V";
        String renderItemModelMethod = LucraftForgeLoading.runtimeObfuscationEnabled ? "renderItem" : "func_184392_a";
        String renderItemModelDesc = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;Z)V";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        InsnList list = new InsnList();
        for (int j = 0; j < classNode.methods.size(); ++j) {
            MethodNode method = (MethodNode)classNode.methods.get(j);
            if (!renderMethod.equals(method.name) || !renderDesc.equals(method.desc)) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (methodNode.name.equals(renderItemModelMethod) && methodNode.desc.equals(renderItemModelDesc)) {
                        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        list.add((AbstractInsnNode)new VarInsnNode(25, 3));
                        list.add((AbstractInsnNode)new VarInsnNode(21, 4));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftClientHooks", "renderItem", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;Z)V", false));
                    }
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClassASMModelBiped(String name, byte[] bytes, boolean obf) {
        String renderMethod = LucraftForgeLoading.runtimeObfuscationEnabled ? "render" : "func_78088_a";
        String renderDesc = "(Lnet/minecraft/entity/Entity;FFFFFF)V";
        String setRotationAnglesMethod = LucraftForgeLoading.runtimeObfuscationEnabled ? "setRotationAngles" : "func_78087_a";
        String setRotationAnglesDesc = "(FFFFFFLnet/minecraft/entity/Entity;)V";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        InsnList list = new InsnList();
        for (int j = 0; j < classNode.methods.size(); ++j) {
            MethodNode method = (MethodNode)classNode.methods.get(j);
            if (!renderMethod.equals(method.name) || !renderDesc.equals(method.desc)) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (methodNode.name.equals(setRotationAnglesMethod) && methodNode.desc.equals(setRotationAnglesDesc)) {
                        list.add(node);
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 2));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 3));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 4));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 5));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 6));
                        list.add((AbstractInsnNode)new VarInsnNode(23, 7));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftClientHooks", "renderBipedPre", "(Lnet/minecraft/client/model/ModelBiped;Lnet/minecraft/entity/Entity;FFFFFF)V", false));
                        continue;
                    }
                }
                if (node.getOpcode() == 177) {
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 2));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 3));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 4));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 5));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 6));
                    list.add((AbstractInsnNode)new VarInsnNode(23, 7));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftClientHooks", "renderBipedPost", "(Lnet/minecraft/client/model/ModelBiped;Lnet/minecraft/entity/Entity;FFFFFF)V", false));
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchClassASMRendererEntityLiving(String name, byte[] bytes, boolean obf) {
        String targetMethodName = LucraftForgeLoading.runtimeObfuscationEnabled ? "prepareScale" : "func_188322_c";
        String targetScaleMethodname = LucraftForgeLoading.runtimeObfuscationEnabled ? "scale" : "func_179152_a";
        String targetIsnName = "(Lnet/minecraft/entity/EntityLivingBase;F)F";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (int i = 0; i < classNode.methods.size(); ++i) {
            MethodNode method = (MethodNode)classNode.methods.get(i);
            if (!targetMethodName.equals(method.name) || !targetIsnName.equals(method.desc)) continue;
            InsnList insnList = method.instructions;
            for (int j = 0; j < insnList.size(); ++j) {
                AbstractInsnNode insnNote = method.instructions.get(j);
                if (insnNote.getOpcode() != 184) continue;
                MethodInsnNode method_0 = (MethodInsnNode)insnNote;
                if (!targetScaleMethodname.contains(method_0.name)) continue;
                InsnList insnList_0 = new InsnList();
                insnList_0.add((AbstractInsnNode)new VarInsnNode(25, 1));
                String parameter = "(Lnet/minecraft/entity/EntityLivingBase;)V";
                MethodInsnNode method_1 = new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftClientHooks", "preRenderCallBack", parameter, false);
                insnList_0.add((AbstractInsnNode)method_1);
                insnList.insert((AbstractInsnNode)method_0, insnList_0);
                break block0;
            }
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClassASMMinecraftServer(String name, byte[] bytes, boolean obf) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("run") || !method.desc.equals("()V")) continue;
            InsnList list = new InsnList();
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node instanceof LdcInsnNode) {
                    LdcInsnNode ldcNode = (LdcInsnNode)node;
                    if (ldcNode.cst instanceof Long && (Long)ldcNode.cst == 50L) {
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftTickrateHooks", "getTickrate", "()J", false));
                        continue;
                    }
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClassASMSoundSystem(String name, byte[] bytes, boolean obf) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("setPitch") || !method.desc.equals("(Ljava/lang/String;F)V")) continue;
            InsnList inst = new InsnList();
            inst.add((AbstractInsnNode)new VarInsnNode(23, 2));
            inst.add((AbstractInsnNode)new FieldInsnNode(178, "lucraft/mods/lucraftcore/access/LucraftTickrateHooks", "GAME_SPEED", "F"));
            inst.add((AbstractInsnNode)new InsnNode(106));
            inst.add((AbstractInsnNode)new VarInsnNode(56, 2));
            inst.add(method.instructions);
            method.instructions = inst;
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClassEntityLivingBase(String name, byte[] bytes, boolean obf) {
        String armSwingMethod = LucraftForgeLoading.runtimeObfuscationEnabled ? "getArmSwingAnimationEnd" : "func_82166_i";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(armSwingMethod) || !method.desc.equals("()I")) continue;
            InsnList list = new InsnList();
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (node.getOpcode() == 172) {
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "lucraft/mods/lucraftcore/access/LucraftHooks", "getArmSwing", "(Lnet/minecraft/entity/Entity;)I", false));
                    list.add((AbstractInsnNode)new InsnNode(108));
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

