/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.blocks;

import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.blocks.BlockBase;
import lucraft.mods.lucraftcore.items.ItemBlockMetal;
import lucraft.mods.lucraftcore.util.EnumMetalTypes;
import lucraft.mods.lucraftcore.util.LCModelEntry;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class BlockMetal
extends BlockBase {
    public static final PropertyEnum<EnumMetalTypes> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMetalTypes.class);

    public BlockMetal() {
        super("block", false, Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(LucraftCore.tabMetals);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockMetal(this));
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            OreDictionary.registerOre((String)(this.name + type.getMetalName()), (ItemStack)new ItemStack((Block)this, 1, type.getId()));
            LucraftCore.proxy.registerModel(this, new LCModelEntry(type.getId(), this.name + type.getMetalName()));
        }
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        EnumMetalTypes metal = EnumMetalTypes.getTypeFromMetadata(world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
        return metal.getResistance() / 2.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        EnumMetalTypes metal = EnumMetalTypes.getTypeFromMetadata(world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
        return metal.getResistance();
    }

    public EnumMetalTypes getMetalType(IBlockState state) {
        return (EnumMetalTypes)((Object)state.func_177229_b(TYPE));
    }

    public int getHarvestLevel(IBlockState state) {
        return this.getMetalType(state).getHarvestLevel() * 2;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int func_180651_a(IBlockState state) {
        return this.getMetalType(state).getId();
    }

    public void func_149666_a(Item item, CreativeTabs creativetab, List<ItemStack> list) {
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            list.add(new ItemStack(item, 1, type.getId()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumMetalTypes.getTypeFromMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int typebits = this.getMetalType(state).getId();
        return typebits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }
}

