/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.client.gui.buttons.GuiButton10x;
import lucraft.mods.lucraftcore.container.ContainerDummy;
import lucraft.mods.lucraftcore.superpower.ISuperpowerAbilityCoordinates;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LCRenderHelper;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.opengl.GL11;

public class GuiAbilityTree
extends GuiContainer {
    public static final ResourceLocation TEX = new ResourceLocation("lucraftcore:textures/gui/abilities.png");
    public EntityPlayer player;
    public Superpower superpower;
    public SuperpowerPlayerHandler data;
    public int offsetX;
    public int offsetY;
    public int prevMouseX;
    public int prevMouseY;
    public int selectedAbility = -1;

    public GuiAbilityTree(EntityPlayer player) {
        super((Container)new ContainerDummy());
        this.player = player;
        this.superpower = SuperpowerHandler.getSuperpower(player);
        this.data = SuperpowerHandler.getSuperpowerPlayerHandler(player);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 256;
        this.field_147000_g = 189;
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonExt(1, i + 186, j + 165, 50, 18, LucraftCoreUtil.translateToLocal("gui.cancel")));
        this.field_146292_n.add(new GuiButton10x(3, i + 239, j + 90, "?"));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Ability ability;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i + this.field_146999_f / 2 + this.offsetX;
        int y = j + this.field_147000_g / 2 + this.offsetY;
        if (this.isInArea(mouseX, mouseY) && this.superpower instanceof ISuperpowerAbilityCoordinates) {
            ISuperpowerAbilityCoordinates coordinates = (ISuperpowerAbilityCoordinates)((Object)this.superpower);
            for (Ability ab : this.data.getAbilities()) {
                Vec2f vec = coordinates.getDisplayCoordinatesForAbility(ab);
                if (vec == null) continue;
                int abX = (int)((float)x + vec.field_189982_i * 30.0f);
                int abY = (int)((float)y + vec.field_189983_j * 30.0f);
                if (mouseX < abX || mouseX > abX + 22 || mouseY < abY || mouseY > abY + 22) continue;
                LCRenderHelper.drawStringList(Arrays.asList(ab.getDisplayName()), mouseX + 10, mouseY, true);
            }
        }
        GuiButton info = (GuiButton)this.field_146292_n.get(1);
        if (this.selectedAbility >= 0 && info.field_146124_l && mouseX >= info.field_146128_h && mouseX <= info.field_146128_h + info.field_146120_f && mouseY >= info.field_146129_i && mouseY <= info.field_146129_i + info.field_146121_g && (ability = this.data.getAbilities().get(this.selectedAbility)) != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : ability.getDisplayDescription().split("\n")) {
                list.add(s);
            }
            LCRenderHelper.drawStringList(list, mouseX + 10, mouseY, true);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i + this.field_146999_f / 2 + this.offsetX;
        int y = j + this.field_147000_g / 2 + this.offsetY;
        if (this.superpower.getPlayerRenderer() != null) {
            this.superpower.getPlayerRenderer().applyColor();
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEX);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(TEX);
        if (this.superpower.canLevelUp() && this.data != null) {
            this.func_73729_b(i + 80, j + 171, 0, 215, 81, 5);
            float xp = (float)this.data.getXP() / (float)this.superpower.getXPForLevel(this.data.getLevel() + 1);
            if (this.data.getLevel() == this.superpower.getMaxLevel()) {
                xp = 1.0f;
            }
            this.func_73729_b(i + 80, j + 171, 0, 220, (int)(xp * 81.0f), 5);
            LCRenderHelper.drawStringWithOutline("" + this.data.getLevel(), i + 67, j + 170, 10014827, 531473);
            if (this.data.getLevel() < this.superpower.getMaxLevel()) {
                boolean unicode = this.field_146297_k.field_71466_p.func_82883_a();
                this.field_146297_k.field_71466_p.func_78264_a(true);
                String xpProgress = this.data.getXP() + "/" + this.superpower.getXPForLevel(this.data.getLevel() + 1);
                int length = 120 - this.field_146297_k.field_71466_p.func_78256_a(xpProgress) / 2;
                this.field_146297_k.field_71466_p.func_78276_b(xpProgress, i + length, j + 175, 0x555555);
                this.field_146297_k.field_71466_p.func_78264_a(unicode);
            }
        }
        String name = TextFormatting.UNDERLINE + this.superpower.getDisplayName();
        int titleX = this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(name) / 2;
        this.field_146297_k.field_71466_p.func_78276_b(name, i + titleX, j + 10, 0x373737);
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3089);
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        GL11.glScissor((int)(this.field_146297_k.field_71443_c / 2 - (this.field_146999_f - 42) / 2 * res.func_78325_e()), (int)(this.field_146297_k.field_71440_d / 2 - (this.field_147000_g - 56) / 2 * res.func_78325_e() - 1), (int)(214 * res.func_78325_e()), (int)(133 * res.func_78325_e()));
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(this.getBackgroundBlockState());
        GlStateManager.func_179124_c((float)0.6f, (float)0.6f, (float)0.6f);
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (int blocks1 = 0; blocks1 < 33; ++blocks1) {
            for (int blocks2 = 0; blocks2 < 28; ++blocks2) {
                this.func_175175_a(x - 257 + blocks1 * 16, y - 216 + blocks2 * 16, sprite, 16, 16);
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.superpower instanceof ISuperpowerAbilityCoordinates) {
            Vec2f vec;
            ISuperpowerAbilityCoordinates coordinates = (ISuperpowerAbilityCoordinates)((Object)this.superpower);
            for (Ability ab : this.data.getAbilities()) {
                vec = coordinates.getDisplayCoordinatesForAbility(ab);
                if (vec == null || ab.getDependentAbility() == null || coordinates.getDisplayCoordinatesForAbility(ab.getDependentAbility()) == null) continue;
                Vec2f vecEnd = coordinates.getDisplayCoordinatesForAbility(ab.getDependentAbility());
                int startX = (int)((float)x + vec.field_189982_i * 30.0f + 11.0f);
                int endX = (int)((float)x + vecEnd.field_189982_i * 30.0f + 11.0f);
                int startY = (int)((float)y + vec.field_189983_j * 30.0f + 10.0f);
                int endY = (int)((float)y + vecEnd.field_189983_j * 30.0f + 11.0f);
                startX = startX < endX ? (startX += 12) : (startX -= 14);
                this.field_146297_k.func_110434_K().func_110577_a(TEX);
                for (int xLine = Math.min(startX, endX); xLine < Math.max(startX, endX) + 2; ++xLine) {
                    this.func_73729_b(xLine, startY, 48, 204, 1, 2);
                }
                for (int yLine = Math.min(startY, endY); yLine < Math.max(startY, endY); ++yLine) {
                    this.func_73729_b(endX, yLine, 48, 204, 2, 1);
                }
                if (startX < endX) {
                    this.func_73729_b(startX - 1, startY - 5, 69, 189, 7, 11);
                    continue;
                }
                this.func_73729_b(startX - 4, startY - 5, 76, 189, 7, 11);
            }
            for (Ability ab : this.data.getAbilities()) {
                vec = coordinates.getDisplayCoordinatesForAbility(ab);
                if (vec == null) continue;
                int abX = (int)((float)x + vec.field_189982_i * 30.0f);
                int abY = (int)((float)y + vec.field_189983_j * 30.0f);
                this.field_146297_k.func_110434_K().func_110577_a(TEX);
                if (this.isSelected(ab)) {
                    this.func_73729_b(abX - 3, abY - 3, 83, 189, 28, 28);
                }
                this.func_73729_b(abX, abY, 0, 189, 22, 22);
                ab.drawIcon(this.field_146297_k, (Gui)this, abX + 3, abY + 3);
            }
        }
        this.func_73728_b(2, 2, 22, 0);
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
    }

    public boolean isSelected(Ability ability) {
        return this.data.getAbilities().contains(ability) && this.data.getAbilities().indexOf(ability) == this.selectedAbility;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i + this.field_146999_f / 2 + this.offsetX;
        int y = j + this.field_147000_g / 2 + this.offsetY;
        if (this.isInArea(mouseX, mouseY) && this.superpower instanceof ISuperpowerAbilityCoordinates) {
            ISuperpowerAbilityCoordinates coordinates = (ISuperpowerAbilityCoordinates)((Object)this.superpower);
            for (Ability ab : this.data.getAbilities()) {
                Vec2f vec = coordinates.getDisplayCoordinatesForAbility(ab);
                if (vec == null) continue;
                int abX = (int)((float)x + vec.field_189982_i * 30.0f);
                int abY = (int)((float)y + vec.field_189983_j * 30.0f);
                if (mouseX < abX || mouseX > abX + 22 || mouseY < abY || mouseY > abY + 22) continue;
                this.selectedAbility = this.data.getAbilities().indexOf(ab);
                this.onAbilityClicked(ab);
            }
        }
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.isInArea(mouseX, mouseY) && clickedMouseButton == 0) {
            this.offsetX = MathHelper.func_76125_a((int)(this.offsetX + mouseX - this.prevMouseX), (int)-150, (int)150);
            this.offsetY = MathHelper.func_76125_a((int)(this.offsetY + mouseY - this.prevMouseY), (int)-150, (int)150);
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public IBlockState getBackgroundBlockState() {
        return Blocks.field_150348_b.func_176223_P();
    }

    public void onAbilityClicked(Ability ability) {
    }

    public boolean isInArea(int x, int y) {
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        return x >= i + 21 && x < i + this.field_146999_f - 21 && y >= j + 28 && y < j + this.field_147000_g - 28;
    }
}

