/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.abilities.Ability;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LCConfig {
    public static boolean renderFirstPersonHand;
    public static boolean renderAbilityBar;
    public static boolean stealSuperpower;
    public static boolean giveSuperpower;
    public static List<ResourceLocation> disabledAbilities;
    public static Configuration config;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        LCConfig.loadConfig();
    }

    public static void loadConfig() {
        stealSuperpower = config.getBoolean("Steal Superpower", "general", false, "If enabled you can remove and steal the superpower of other player with the Anti-Superpower-Serum or Superpower Capsule");
        giveSuperpower = config.getBoolean("Give Superpower", "general", true, "If enabled you can give other players a superpower with a Superpower Capsule");
        for (String s : config.getStringList("Disabled Abilities", "general", new String[]{"modid:abilityname", "lucraftcore:test"}, "List of disabled abilities. Use /abilities ingame to get a list of all available abilities", new String[0])) {
            disabledAbilities.add(new ResourceLocation(s));
        }
        renderFirstPersonHand = config.getBoolean("Render First Person Armor Hand", "client", true, "If supported, it will render the armor on you hand in first person");
        renderAbilityBar = config.getBoolean("Render Ability Bar", "client", true, "If enabled the ability bar in the top left corner will be rendered when other mods add support for it");
        config.save();
    }

    @SubscribeEvent
    public void configChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID() == "lucraftcore") {
            LCConfig.loadConfig();
        }
    }

    public static boolean isAbilityEnabled(Ability ability) {
        return LCConfig.isAbilityEnabled(ability.getClass());
    }

    public static boolean isAbilityEnabled(Class<? extends Ability> clz) {
        return !disabledAbilities.contains(Ability.REGISTRY.func_177774_c(clz));
    }

    public static List<Ability> removeDisabledAbilities(List<Ability> list) {
        ArrayList<Ability> newList = new ArrayList<Ability>();
        for (Ability ab : list) {
            boolean isDisabled = false;
            Ability ab1 = ab;
            while (ab1.getDependentAbility() != null) {
                if (LCConfig.isAbilityEnabled(ab1 = ab1.getDependentAbility())) continue;
                isDisabled = true;
            }
            if (!LCConfig.isAbilityEnabled(ab) || isDisabled) continue;
            newList.add(ab);
        }
        return newList;
    }

    static {
        disabledAbilities = new ArrayList<ResourceLocation>();
    }
}

