/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.extendedinventory;

import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ExtendedInventoryProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    private IPlayerExtendedInventory inventory = null;

    public ExtendedInventoryProvider(IPlayerExtendedInventory inventory) {
        this.inventory = inventory;
    }

    public static IPlayerExtendedInventory get(EntityPlayer player) {
        return player.hasCapability(LucraftCore.EXTENDED_INVENTORY, null) ? (IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null) : null;
    }

    public NBTTagCompound serializeNBT() {
        return this.inventory.saveNBTData();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.loadNBTData(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return LucraftCore.EXTENDED_INVENTORY != null && capability == LucraftCore.EXTENDED_INVENTORY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (LucraftCore.EXTENDED_INVENTORY != null && capability == LucraftCore.EXTENDED_INVENTORY) {
            return (T)this.inventory;
        }
        return null;
    }
}

