/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.integration.jei;

import lucraft.mods.lucraftcore.blocks.LCBlocks;
import lucraft.mods.lucraftcore.client.gui.GuiCompressor;
import lucraft.mods.lucraftcore.client.gui.GuiDNAExtractor;
import lucraft.mods.lucraftcore.client.gui.GuiPulverizer;
import lucraft.mods.lucraftcore.client.gui.GuiSuitMaker;
import lucraft.mods.lucraftcore.container.ContainerCompressor;
import lucraft.mods.lucraftcore.container.ContainerPulverizer;
import lucraft.mods.lucraftcore.integration.jei.compressor.CompressorCategory;
import lucraft.mods.lucraftcore.integration.jei.compressor.CompressorRecipeHandler;
import lucraft.mods.lucraftcore.integration.jei.compressor.CompressorRecipeMaker;
import lucraft.mods.lucraftcore.integration.jei.dnaextractor.DNAExtractorRecipeCategory;
import lucraft.mods.lucraftcore.integration.jei.dnaextractor.DNAExtractorRecipeHandler;
import lucraft.mods.lucraftcore.integration.jei.dnaextractor.DNAExtractorRecipeMaker;
import lucraft.mods.lucraftcore.integration.jei.pulverizer.PulverizerCategory;
import lucraft.mods.lucraftcore.integration.jei.pulverizer.PulverizerRecipeHandler;
import lucraft.mods.lucraftcore.integration.jei.pulverizer.PulverizerRecipeMaker;
import lucraft.mods.lucraftcore.integration.jei.suitmaker.SuitMakerJEIRecipeHandler;
import lucraft.mods.lucraftcore.integration.jei.suitmaker.SuitMakerRecipeCategory;
import lucraft.mods.lucraftcore.integration.jei.suitmaker.SuitMakerRecipeMaker;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class LucraftCoreJEIPlugin
implements IModPlugin {
    public static final String PULVERIZER = "lucraftcore.pulverizer";
    public static final String COMPRESSOR = "lucraftcore.compressor";
    public static final String SUIT_MAKER = "lucraftcore.suit_maker";
    public static final String DNA_EXTRACTOR = "lucraftcore.dna_extractor";
    public static IGuiHelper guiHelper;

    public void register(IModRegistry reg) {
        IGuiHelper guiHelper;
        IJeiHelpers jeiHelpers = reg.getJeiHelpers();
        LucraftCoreJEIPlugin.guiHelper = guiHelper = jeiHelpers.getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new PulverizerCategory(guiHelper), new CompressorCategory(guiHelper), new SuitMakerRecipeCategory(guiHelper), new DNAExtractorRecipeCategory(guiHelper)});
        reg.addRecipeHandlers(new IRecipeHandler[]{new PulverizerRecipeHandler(), new CompressorRecipeHandler(), new SuitMakerJEIRecipeHandler(), new DNAExtractorRecipeHandler()});
        reg.addRecipeClickArea(GuiPulverizer.class, 78, 32, 28, 23, new String[]{PULVERIZER});
        reg.addRecipeClickArea(GuiCompressor.class, 78, 32, 28, 23, new String[]{COMPRESSOR});
        reg.addRecipeClickArea(GuiSuitMaker.class, 91, 7, 48, 72, new String[]{SUIT_MAKER});
        reg.addRecipeClickArea(GuiDNAExtractor.class, 60, 35, 30, 15, new String[]{DNA_EXTRACTOR});
        IRecipeTransferRegistry recipeTransferRegistry = reg.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerPulverizer.class, PULVERIZER, 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCompressor.class, COMPRESSOR, 0, 1, 3, 36);
        reg.addRecipes(PulverizerRecipeMaker.getPulverizerRecipes(jeiHelpers));
        reg.addRecipes(CompressorRecipeMaker.getCompressorRecipes(jeiHelpers));
        reg.addRecipes(SuitMakerRecipeMaker.getSuitMakerRecipes());
        reg.addRecipes(DNAExtractorRecipeMaker.getDNAExtractorRecipes());
        reg.addRecipeCategoryCraftingItem(new ItemStack(LCBlocks.pulverizer), new String[]{PULVERIZER});
        reg.addRecipeCategoryCraftingItem(new ItemStack(LCBlocks.compressor), new String[]{COMPRESSOR});
        reg.addRecipeCategoryCraftingItem(new ItemStack(LCBlocks.suitMaker), new String[]{SUIT_MAKER});
        reg.addRecipeCategoryCraftingItem(new ItemStack(LCBlocks.dnaExtractor), new String[]{DNA_EXTRACTOR});
    }

    public void onRuntimeAvailable(IJeiRuntime arg0) {
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry arg0) {
    }
}

