/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.events.LucraftCoreKeyEvent;
import lucraft.mods.lucraftcore.events.PlayerEmptyClickEvent;
import lucraft.mods.lucraftcore.extendedinventory.ExtendedPlayerInventory;
import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.IOpenableHelmet;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSendInfoToServer
implements IMessage {
    public InfoType type;
    public int info;
    public static HashMap<Integer, InfoType> ids = new HashMap();

    public MessageSendInfoToServer() {
    }

    public MessageSendInfoToServer(InfoType type) {
        this.type = type;
        this.info = 0;
    }

    public MessageSendInfoToServer(InfoType type, int i) {
        this.type = type;
        this.info = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = InfoType.getInfoTypeFromId(buf.readInt());
        this.info = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.info);
    }

    public static enum InfoType {
        LEFT_CLICK,
        RIGHT_CLICK,
        EXTENDED_INVENTORY,
        SYNC_DATA,
        KEY_PRESS,
        KEY_UNPRESS,
        KNOCK_OUT_TOGGLE;


        private InfoType() {
            ids.put(this.ordinal(), this);
        }

        public static InfoType getInfoTypeFromId(int id) {
            return ids.get(id);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageSendInfoToServer> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final MessageSendInfoToServer message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    InfoType type = message.type;
                    switch (type) {
                        case LEFT_CLICK: {
                            MinecraftForge.EVENT_BUS.post((Event)new PlayerEmptyClickEvent.LeftClick(player));
                            break;
                        }
                        case RIGHT_CLICK: {
                            MinecraftForge.EVENT_BUS.post((Event)new PlayerEmptyClickEvent.RightClick(player));
                            break;
                        }
                        case KEY_PRESS: {
                            LucraftKeys key = LucraftKeys.getKeyFromId(message.info);
                            MinecraftForge.EVENT_BUS.post((Event)new LucraftCoreKeyEvent.Server(key, player, true));
                            if (key.type == LucraftKeys.LucraftKeyTypes.HELMET) {
                                if (player.func_184582_a(EntityEquipmentSlot.HEAD) == null || !(player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof IOpenableHelmet)) break;
                                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                                ((IOpenableHelmet)helmet.func_77973_b()).openCloseHelmet((Entity)player, helmet);
                                break;
                            }
                            if (key.type == LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION || key.type == LucraftKeys.LucraftKeyTypes.ARMOR_ACTION) {
                                Ability ability;
                                SuperpowerPlayerHandler handler = SuperpowerHandler.getSuperpowerPlayerHandler(player);
                                SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)player);
                                Ability ability2 = key.type == LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION ? (handler != null ? handler.getAbilityForKey(key) : null) : (ability = key.type == LucraftKeys.LucraftKeyTypes.ARMOR_ACTION && suitSet != null ? ((ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).getSuitAbilityForKey(key) : null);
                                if (key.type == LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION && handler != null) {
                                    handler.onSuperpowerAction(key);
                                }
                                if (ability == null || !ability.isUnlocked() || !ability.checkConditions()) break;
                                if (ability.getAbilityType() == Ability.AbilityType.ACTION) {
                                    if (ability.hasCooldown()) {
                                        if (ability.getCooldown() != 0) break;
                                        ability.action();
                                        ability.setEnabled(false);
                                        ability.setCooldown(ability.getMaxCooldown());
                                        break;
                                    }
                                    ability.action();
                                    break;
                                }
                                if (ability.getAbilityType() == Ability.AbilityType.TOGGLE) {
                                    ability.action();
                                    break;
                                }
                                if (ability.getAbilityType() != Ability.AbilityType.HELD) break;
                                ability.setEnabled(true);
                                break;
                            }
                            if (key.type != LucraftKeys.LucraftKeyTypes.EXTENDED_INVENTORY || !player.hasCapability(LucraftCore.EXTENDED_INVENTORY, null)) break;
                            ExtendedPlayerInventory inv = ((IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory();
                            if (key.itemType == IItemExtendedInventory.ExtendedInventoryItemType.NECKLACE && inv.func_70301_a(0) != null) {
                                ((IItemExtendedInventory)inv.func_70301_a(0).func_77973_b()).onPressedButton(inv.func_70301_a(0), player);
                                break;
                            }
                            if (key.itemType == IItemExtendedInventory.ExtendedInventoryItemType.MANTLE && inv.func_70301_a(1) != null) {
                                ((IItemExtendedInventory)inv.func_70301_a(1).func_77973_b()).onPressedButton(inv.func_70301_a(1), player);
                                break;
                            }
                            if (key.itemType != IItemExtendedInventory.ExtendedInventoryItemType.WRIST || inv.func_70301_a(2) == null) break;
                            ((IItemExtendedInventory)inv.func_70301_a(2).func_77973_b()).onPressedButton(inv.func_70301_a(2), player);
                            break;
                        }
                        case KEY_UNPRESS: {
                            Ability ability;
                            LucraftKeys key1 = LucraftKeys.getKeyFromId(message.info);
                            MinecraftForge.EVENT_BUS.post((Event)new LucraftCoreKeyEvent.Server(key1, player, false));
                            if (key1.type != LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION && key1.type != LucraftKeys.LucraftKeyTypes.ARMOR_ACTION) break;
                            SuperpowerPlayerHandler handler = SuperpowerHandler.getSuperpowerPlayerHandler(player);
                            SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)player);
                            Ability ability3 = key1.type == LucraftKeys.LucraftKeyTypes.SUPERPOWER_ACTION ? (handler != null ? handler.getAbilityForKey(key1) : null) : (ability = key1.type == LucraftKeys.LucraftKeyTypes.ARMOR_ACTION && suitSet != null ? ((ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null)).getSuitAbilityForKey(key1) : null);
                            if (ability == null || !ability.isUnlocked() || ability.getAbilityType() != Ability.AbilityType.HELD) break;
                            ability.setEnabled(false);
                            break;
                        }
                        case EXTENDED_INVENTORY: {
                            player.openGui((Object)LucraftCore.instance, 43, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                            break;
                        }
                        case KNOCK_OUT_TOGGLE: {
                            ISuperpowerCapability cap = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
                            cap.setKnockOutModeEnabled(!cap.isKnockOutModeEnabled());
                            LucraftCoreUtil.sendSuperpowerUpdatePacket(player);
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

