/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.extendedinventory.ExtendedPlayerInventory;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncExtendedInventory
implements IMessage {
    public String uuid;
    public int slot;
    public ItemStack stack;

    public MessageSyncExtendedInventory() {
    }

    public MessageSyncExtendedInventory(EntityPlayer player, int slot) {
        this.uuid = player.func_110124_au().toString();
        this.slot = slot;
        if (player.hasCapability(LucraftCore.EXTENDED_INVENTORY, null)) {
            ExtendedPlayerInventory inv = ((IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory();
            this.stack = inv.func_70301_a(slot);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.slot = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        buf.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncExtendedInventory> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, final MessageSyncExtendedInventory message, final MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer en;
                    if (message != null && ctx != null && (en = LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_152378_a(UUID.fromString(message.uuid))) != null) {
                        ExtendedPlayerInventory inv = ((IPlayerExtendedInventory)en.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory();
                        inv.func_70299_a(message.slot, message.stack);
                    }
                }
            });
            return null;
        }
    }
}

