/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import lucraft.mods.lucraftcore.network.MessageSendInfoToClient;
import lucraft.mods.lucraftcore.network.MessageSendInfoToServer;
import lucraft.mods.lucraftcore.network.MessageShowActionBar;
import lucraft.mods.lucraftcore.network.MessageSpawnParticle;
import lucraft.mods.lucraftcore.network.MessageSuperpowerStyle;
import lucraft.mods.lucraftcore.network.MessageSwingArm;
import lucraft.mods.lucraftcore.network.MessageSyncDisabledAbilities;
import lucraft.mods.lucraftcore.network.MessageSyncExtendedInventory;
import lucraft.mods.lucraftcore.network.MessageSyncPlayerData;
import lucraft.mods.lucraftcore.network.MessageSyncPlayerDataRequest;
import lucraft.mods.lucraftcore.network.MessageSyncPotionEffects;
import lucraft.mods.lucraftcore.network.MessageSyncSize;
import lucraft.mods.lucraftcore.network.MessageSyncSizeRequest;
import lucraft.mods.lucraftcore.network.MessageToggleAbilityVisibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("lucraftcore");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(MessageSendInfoToServer.Handler.class, MessageSendInfoToServer.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSyncPlayerDataRequest.Handler.class, MessageSyncPlayerDataRequest.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSendInfoToClient.Handler.class, MessageSendInfoToClient.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSyncPlayerData.Handler.class, MessageSyncPlayerData.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSyncExtendedInventory.Handler.class, MessageSyncExtendedInventory.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSwingArm.Handler.class, MessageSwingArm.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSyncSize.Handler.class, MessageSyncSize.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSyncSizeRequest.Handler.class, MessageSyncSizeRequest.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageShowActionBar.Handler.class, MessageShowActionBar.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSpawnParticle.Handler.class, MessageSpawnParticle.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSuperpowerStyle.Handler.class, MessageSuperpowerStyle.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSyncPotionEffects.Handler.class, MessageSyncPotionEffects.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageToggleAbilityVisibility.Handler.class, MessageToggleAbilityVisibility.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSyncDisabledAbilities.Handler.class, MessageSyncDisabledAbilities.class, Side.CLIENT);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

