/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpower;

import java.util.List;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.client.gui.GuiAbilityList;
import lucraft.mods.lucraftcore.client.gui.GuiCustomizer;
import lucraft.mods.lucraftcore.client.gui.book.BookChapter;
import lucraft.mods.lucraftcore.client.gui.book.BookPage;
import lucraft.mods.lucraftcore.client.gui.book.heroguide.BookPageSuperPower;
import lucraft.mods.lucraftcore.config.LCConfig;
import lucraft.mods.lucraftcore.superpower.ISuperpowerPlayerRenderer;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Superpower {
    private String name;

    public Superpower(String name) {
        this.name = name;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getDisplayName() {
        return LucraftCoreUtil.translateToLocal("superpower." + this.name + ".name");
    }

    public abstract SuperpowerPlayerHandler getNewSuperpowerHandler(EntityPlayer var1);

    public boolean shouldAppearInHeroGuideBook() {
        return true;
    }

    public String getDescription() {
        return LucraftCoreUtil.translateToLocal("superpower." + this.name + ".description");
    }

    public abstract void renderIcon(Minecraft var1, int var2, int var3);

    protected List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        return list;
    }

    public List<Ability> getDefaultAbilities(EntityPlayer player, List<Ability> list) {
        return LCConfig.removeDisabledAbilities(this.addDefaultAbilities(player, list));
    }

    public boolean canLevelUp() {
        return false;
    }

    public int getMaxLevel() {
        return 0;
    }

    public int getXPForLevel(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return (level - 1) * 1000;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 10000;
            }
            case 15: {
                return 15000;
            }
            case 16: 
            case 17: 
            case 18: {
                return 20000;
            }
            case 19: 
            case 20: {
                return 25000;
            }
            case 21: {
                return 50000;
            }
            case 22: {
                return 75000;
            }
            case 23: {
                return 100000;
            }
            case 24: {
                return 125000;
            }
            case 25: {
                return 150000;
            }
            case 26: {
                return 190000;
            }
            case 27: {
                return 20000;
            }
            case 28: {
                return 250000;
            }
            case 29: {
                return 300000;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return 350000;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return 375000;
            }
        }
        return 0;
    }

    public String getXPTranslationName() {
        return "lucraftcore.info.xp";
    }

    public String getXPName() {
        return LucraftCoreUtil.translateToLocal(this.getXPTranslationName());
    }

    @SideOnly(value=Side.CLIENT)
    public ISuperpowerPlayerRenderer getPlayerRenderer() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getAbilityGui(EntityPlayer player) {
        return new GuiAbilityList(player);
    }

    public boolean canCustomize() {
        return false;
    }

    public NBTTagCompound getDefaultStyleTag() {
        return new NBTTagCompound();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiCustomizer getCustomizerGui(EntityPlayer player) {
        return null;
    }

    public int getRequiredLevelForCustomization() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BookPage getBookPage(BookChapter chapter) {
        return new BookPageSuperPower(chapter, this);
    }
}

