/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpower;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class SuperpowerPlayerHandler {
    private List<Ability> abilities = new ArrayList<Ability>();
    private int xp;
    private int level;
    private NBTTagCompound style;
    public EntityPlayer player;
    public Superpower superpower;

    public SuperpowerPlayerHandler(EntityPlayer player, Superpower superpower) {
        this.player = player;
        this.superpower = superpower;
    }

    public void update(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            for (Ability ability : this.abilities) {
                ability.onUpdate();
            }
        }
        this.onUpdate(phase);
    }

    public void onUpdate(TickEvent.Phase phase) {
    }

    public void onSuperpowerAction(LucraftKeys key) {
    }

    public void onApplyPower() {
    }

    public void onRemovePower() {
    }

    public void onWorldJoin() {
    }

    public void onRespawn() {
    }

    public List<Ability> getAbilities() {
        return this.abilities;
    }

    public void addAbility(Ability ability) {
        this.getAbilities().add(ability);
    }

    public boolean hasAbility(Ability ability) {
        return this.getAbilities().contains(ability);
    }

    public Ability getAbilityForKey(LucraftKeys key) {
        return null;
    }

    public int getLevel() {
        if (this.superpower.canLevelUp()) {
            return MathHelper.func_76125_a((int)this.level, (int)1, (int)this.superpower.getMaxLevel());
        }
        return 0;
    }

    public int getXP() {
        if (this.superpower.canLevelUp()) {
            return MathHelper.func_76125_a((int)this.xp, (int)0, (int)this.superpower.getXPForLevel(this.getLevel() + 1));
        }
        return 0;
    }

    public void setLevel(int level) {
        if (this.superpower.canLevelUp()) {
            this.level = MathHelper.func_76125_a((int)level, (int)1, (int)this.superpower.getMaxLevel());
            LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
        }
    }

    public void setXP(int xp) {
        if (this.superpower.canLevelUp()) {
            this.xp = MathHelper.func_76125_a((int)xp, (int)0, (int)this.superpower.getXPForLevel(this.getLevel() + 1));
            LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
        }
    }

    public void addXP(int xp) {
        this.addXP(xp, true);
    }

    public void addXP(int xp, boolean showMessage) {
        if (xp > 0 && this.superpower.canLevelUp() && this.level < this.superpower.getMaxLevel()) {
            int max = this.superpower.getXPForLevel(this.level + 1);
            this.setXP(this.getXP() + xp);
            int tB = this.getXP();
            if (showMessage) {
                this.sendXPMessage(xp);
            }
            if (this.getXP() >= max) {
                this.levelUp();
                this.addXP(tB - max, false);
            }
        }
    }

    public void levelUp() {
        if (this.superpower.canLevelUp() && this.level < this.superpower.getMaxLevel()) {
            this.setLevel(this.getLevel() + 1);
            this.setXP(0);
            this.sendLevelUpMessage(this.getLevel());
            this.onLevelUp(this.getLevel());
            LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
        }
    }

    public NBTTagCompound getStyleNBTTag() {
        return this.style;
    }

    public void setStyleNBTTag(NBTTagCompound tag) {
        this.style = tag;
        LucraftCoreUtil.sendSuperpowerUpdatePacketToAllPlayers(this.player);
    }

    public void sendXPMessage(int xp) {
        TextComponentString chat = new TextComponentString(TextFormatting.DARK_GREEN + "+" + xp + " " + TextFormatting.GREEN);
        chat.func_150257_a((ITextComponent)new TextComponentTranslation(this.superpower.getXPTranslationName(), new Object[0]));
        LucraftCoreUtil.showActionBarMessage(this.player, (ITextComponent)chat);
        LucraftCoreUtil.playSound(this.player.func_130014_f_(), this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS);
    }

    public void sendLevelUpMessage(int level) {
        TextComponentTranslation chat = new TextComponentTranslation("lucraftcore.info.levelup", new Object[]{level});
        LucraftCoreUtil.showActionBarMessage(this.player, (ITextComponent)chat);
        LucraftCoreUtil.playSound(this.player.func_130014_f_(), this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS);
    }

    public void onLevelUp(int newLevel) {
    }

    public void unlockAbility(Ability ab) {
        if (ab != null && !ab.isUnlocked() && (ab.getDependentAbility() == null || ab.getDependentAbility().isUnlocked())) {
            ab.setUnlocked(true);
            TextComponentTranslation chat = new TextComponentTranslation("lucraftcore.info.unlocked", new Object[]{new TextComponentTranslation(ab.getTranslationName(), new Object[0])});
            LucraftCoreUtil.showActionBarMessage(this.player, (ITextComponent)chat);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Level", this.level);
        compound.func_74768_a("XP", this.xp);
        compound.func_74782_a("Style", (NBTBase)this.style);
        NBTTagList tagList = new NBTTagList();
        for (Ability ability : this.getAbilities()) {
            tagList.func_74742_a((NBTBase)ability.serializeNBT());
        }
        compound.func_74782_a("Abilities", (NBTBase)tagList);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.level = compound.func_74762_e("Level");
        this.xp = compound.func_74762_e("XP");
        this.style = compound.func_74764_b("Style") ? compound.func_74775_l("Style") : this.superpower.getDefaultStyleTag();
        if (compound.func_150295_c("Abilities", 10).func_74745_c() > 0) {
            List<Object> list = new ArrayList();
            NBTTagList tagList = compound.func_150295_c("Abilities", 10);
            list = this.superpower.getDefaultAbilities(this.player, new ArrayList<Ability>());
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                Class clz = (Class)Ability.REGISTRY.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("Ability")));
                for (Ability ability : list) {
                    if (ability.getClass() != clz) continue;
                    ability.deserializeNBT(nbt);
                }
            }
            Collections.sort(list, new Ability.AbilityComparator());
            this.abilities = list;
        } else {
            List<Ability> list = this.superpower.getDefaultAbilities(this.player, new ArrayList<Ability>());
            Collections.sort(list, new Ability.AbilityComparator());
            this.abilities = list;
        }
    }
}

