/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.tileentities;

import java.util.List;
import lucraft.mods.lucraftcore.blocks.BlockSuitMaker;
import lucraft.mods.lucraftcore.recipes.ISuitMakerRecipe;
import lucraft.mods.lucraftcore.recipes.LucraftCoreRecipes;
import lucraft.mods.lucraftcore.util.TileEntityEnergy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntitySuitMaker
extends TileEntityEnergy
implements IInventory {
    public ItemStack[] suitMakerItemStacks = new ItemStack[17];
    public boolean isWorking = false;
    public int headProgress = 0;
    public int chestProgress = 0;
    public int legsProgress = 0;
    public int bootsProgress = 0;
    public static final int maxProgress = 1200;
    public static final int energyPerTick = 25;

    public TileEntitySuitMaker() {
        super(100000, 256);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockSuitMaker) {
            BlockSuitMaker block = (BlockSuitMaker)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c();
            return new AxisAlignedBB(block.getMinBoundingBox(this.func_145831_w(), this.func_174877_v()), block.getMaxBoundingBox(this.func_145831_w(), this.func_174877_v()).func_177982_a(1, 1, 1));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomFromNBT(compound);
    }

    public void readCustomFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.suitMakerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.suitMakerItemStacks.length) continue;
            this.suitMakerItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.isWorking = compound.func_74767_n("isWorking");
        this.headProgress = compound.func_74762_e("headProgress");
        this.chestProgress = compound.func_74762_e("chestProgress");
        this.legsProgress = compound.func_74762_e("legsProgress");
        this.bootsProgress = compound.func_74762_e("bootsProgress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.writeCustomToNBT(compound);
    }

    public NBTTagCompound writeCustomToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.suitMakerItemStacks.length; ++i) {
            if (this.suitMakerItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.suitMakerItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74757_a("isWorking", this.isWorking);
        compound.func_74768_a("headProgress", this.headProgress);
        compound.func_74768_a("chestProgress", this.chestProgress);
        compound.func_74768_a("legsProgress", this.legsProgress);
        compound.func_74768_a("bootsProgress", this.bootsProgress);
        return compound;
    }

    public int func_70302_i_() {
        return this.suitMakerItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.suitMakerItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.suitMakerItemStacks[index] != null) {
            if (this.suitMakerItemStacks[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.suitMakerItemStacks[index];
                this.suitMakerItemStacks[index] = null;
                return itemstack1;
            }
            ItemStack itemstack = this.suitMakerItemStacks[index].func_77979_a(count);
            if (this.suitMakerItemStacks[index].field_77994_a == 0) {
                this.suitMakerItemStacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.suitMakerItemStacks[index] != null) {
            ItemStack itemstack = this.suitMakerItemStacks[index];
            this.suitMakerItemStacks[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.suitMakerItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.headProgress;
            }
            case 1: {
                return this.chestProgress;
            }
            case 2: {
                return this.legsProgress;
            }
            case 3: {
                return this.bootsProgress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.headProgress = value;
            }
            case 1: {
                this.chestProgress = value;
            }
            case 2: {
                this.legsProgress = value;
            }
            case 3: {
                this.bootsProgress = value;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.suitMakerItemStacks.length; ++i) {
            this.suitMakerItemStacks[i] = null;
        }
    }

    public String func_70005_c_() {
        return "container.suitmaker";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ISuitMakerRecipe helmetRecipe = LucraftCoreRecipes.getHelmetResultFromItems(this.suitMakerItemStacks[0], this.suitMakerItemStacks[1], this.suitMakerItemStacks[2]);
        ISuitMakerRecipe chestplateRecipe = LucraftCoreRecipes.getChestplateResultFromItems(this.suitMakerItemStacks[3], this.suitMakerItemStacks[4], this.suitMakerItemStacks[5]);
        ISuitMakerRecipe legsRecipe = LucraftCoreRecipes.getLegsResultFromItems(this.suitMakerItemStacks[6], this.suitMakerItemStacks[7], this.suitMakerItemStacks[8]);
        ISuitMakerRecipe bootsRecipe = LucraftCoreRecipes.getBootsResultFromItems(this.suitMakerItemStacks[9], this.suitMakerItemStacks[10], this.suitMakerItemStacks[11]);
        if (helmetRecipe != null) {
            if (this.extractEnergy(null, 25, true) == 25 && this.func_70301_a(12) == null) {
                ++this.headProgress;
                this.extractEnergy(null, 25, false);
                if (this.headProgress == 1200) {
                    this.removeIngredientFromSlot(helmetRecipe.getFirstInput(), 0);
                    this.removeIngredientFromSlot(helmetRecipe.getSecondInput(), 1);
                    this.removeIngredientFromSlot(helmetRecipe.getThirdInput(), 2);
                    this.func_70299_a(12, helmetRecipe.getOutput().func_77946_l());
                    this.headProgress = 0;
                }
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                this.func_70296_d();
            }
        } else {
            this.headProgress = 0;
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
        if (chestplateRecipe != null) {
            if (this.extractEnergy(null, 25, true) == 25 && this.func_70301_a(13) == null) {
                ++this.chestProgress;
                this.extractEnergy(null, 25, false);
                if (this.chestProgress == 1200) {
                    this.removeIngredientFromSlot(chestplateRecipe.getFirstInput(), 3);
                    this.removeIngredientFromSlot(chestplateRecipe.getSecondInput(), 4);
                    this.removeIngredientFromSlot(chestplateRecipe.getThirdInput(), 5);
                    this.func_70299_a(13, chestplateRecipe.getOutput().func_77946_l());
                    this.chestProgress = 0;
                }
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                this.func_70296_d();
            }
        } else {
            this.chestProgress = 0;
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
        if (legsRecipe != null) {
            if (this.extractEnergy(null, 25, true) == 25 && this.func_70301_a(14) == null) {
                ++this.legsProgress;
                this.extractEnergy(null, 25, false);
                if (this.legsProgress == 1200) {
                    this.removeIngredientFromSlot(legsRecipe.getFirstInput(), 6);
                    this.removeIngredientFromSlot(legsRecipe.getSecondInput(), 7);
                    this.removeIngredientFromSlot(legsRecipe.getThirdInput(), 8);
                    this.func_70299_a(14, legsRecipe.getOutput().func_77946_l());
                    this.legsProgress = 0;
                }
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                this.func_70296_d();
            }
        } else {
            this.legsProgress = 0;
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
        if (bootsRecipe != null) {
            if (this.extractEnergy(null, 25, true) == 25 && this.func_70301_a(15) == null) {
                ++this.bootsProgress;
                this.extractEnergy(null, 25, false);
                if (this.bootsProgress == 1200) {
                    this.removeIngredientFromSlot(bootsRecipe.getFirstInput(), 9);
                    this.removeIngredientFromSlot(bootsRecipe.getSecondInput(), 10);
                    this.removeIngredientFromSlot(bootsRecipe.getThirdInput(), 11);
                    this.func_70299_a(15, bootsRecipe.getOutput().func_77946_l());
                    this.bootsProgress = 0;
                }
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                this.func_70296_d();
            }
        } else {
            this.bootsProgress = 0;
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
    }

    public void removeIngredientFromSlot(List<ItemStack> list, int slot) {
        ItemStack input = this.func_70301_a(slot);
        ItemStack matchingInput = null;
        for (ItemStack s : list) {
            if (s.func_77973_b() != input.func_77973_b() || s.func_77960_j() != input.func_77960_j()) continue;
            matchingInput = s;
        }
        if (matchingInput != null) {
            input.field_77994_a -= matchingInput.field_77994_a;
            if (input.field_77994_a <= 0) {
                input = null;
            }
            this.func_70299_a(slot, input);
        }
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    public boolean canWork(ISuitMakerRecipe helmet, ISuitMakerRecipe chestplate, ISuitMakerRecipe legs, ISuitMakerRecipe boots) {
        return helmet != null && this.func_70301_a(12) == null || chestplate != null && this.func_70301_a(13) == null || legs != null && this.func_70301_a(14) == null || boots != null && this.func_70301_a(15) == null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public ItemStack getFuelStack() {
        return this.func_70301_a(16);
    }

    @Override
    public void removeFuel() {
        --this.func_70301_a((int)16).field_77994_a;
        if (this.func_70301_a((int)16).field_77994_a == 0) {
            this.func_70299_a(16, null);
        }
    }
}

