/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HummingbirdMothModel
extends HierarchicalModel<Butterfly> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "hummingbird_moth"), "main");
    private final ModelPart thorax;
    private final ModelPart left_wing;
    private final ModelPart right_wing;

    public HummingbirdMothModel(ModelPart root) {
        this.thorax = root.getChild("thorax");
        ModelPart wings = this.thorax.getChild("wings");
        this.left_wing = wings.getChild("left_wing");
        this.right_wing = wings.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition thorax = partdefinition.addOrReplaceChild("thorax", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition abdomen = thorax.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        abdomen.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(14, 6).addBox(-3.0f, 0.0f, 3.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition head = thorax.addOrReplaceChild("head", CubeListBuilder.create().texOffs(10, 9).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        head.addOrReplaceChild("proboscis", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.0f, -12.0f, 0.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wings = thorax.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        wings.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-13.0f, (float)1.0f));
        wings.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-13.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(@NotNull Butterfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.thorax.xRot = 0.2853982f + Mth.cos((float)(ageInTicks * 0.1f)) * 0.15f;
        float WING_ARC = 0.2f;
        float WING_SPEED = 13.0f;
        this.right_wing.yRot = Mth.sin((float)(ageInTicks * 13.0f)) * (float)Math.PI * 0.2f;
        this.left_wing.yRot = -this.right_wing.yRot;
    }

    @NotNull
    public ModelPart root() {
        return this.thorax;
    }
}

