/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyEggModel;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyEggRenderer
extends MobRenderer<ButterflyEgg, ButterflyEggModel> {
    public ButterflyEggRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ButterflyEggModel(context.bakeLayer(ButterflyEggModel.LAYER_LOCATION)), 0.05f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ButterflyEgg entity) {
        return entity.getTexture();
    }

    protected void scale(@NotNull ButterflyEgg entity, PoseStack poses, float scale) {
        float s = entity.getScale();
        poses.scale(s, s, s);
    }

    public void render(@NotNull ButterflyEgg entity, float p_115456_, float p_115457_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int p_115460_) {
        Direction direction = entity.getSurfaceDirection();
        if (direction == Direction.UP) {
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else if (direction == Direction.NORTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (direction == Direction.SOUTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.WEST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (direction == Direction.EAST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        super.render((Mob)entity, p_115456_, p_115457_, poseStack, multiBufferSource, p_115460_);
    }
}

