/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.network.protocol.common.custom;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.zip.DataFormatException;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleButterflyData(@NotNull ClientBoundButterflyDataPacket data, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Collection<ButterflyData> butterflyData = data.data();
            for (ButterflyData butterfly : butterflyData) {
                try {
                    ButterflyData.addButterfly(butterfly);
                }
                catch (DataFormatException e) {
                    LogUtils.getLogger().error("Received invalid butterfly data.", (Throwable)e);
                }
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"networking.butterflies.data_sync_failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

