/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.block.BottledButterflyBlock;
import com.bokmcdok.butterflies.world.block.BottledCaterpillarBlock;
import com.bokmcdok.butterflies.world.block.ButterflyFeederBlock;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.block.ButterflyOrigamiBlock;
import com.bokmcdok.butterflies.world.block.FlowerCropBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockRegistry {
    private final DeferredRegister<Block> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"butterflies");
    private List<DeferredHolder<Block, Block>> bottledButterflyBlocks;
    private List<DeferredHolder<Block, Block>> bottledCaterpillarBlocks;
    private DeferredHolder<Block, Block> butterflyFeeder;
    private DeferredHolder<Block, Block> butterflyMicroscope;
    private DeferredHolder<Block, Block> alliumBud;
    private DeferredHolder<Block, Block> azureBluetBud;
    private DeferredHolder<Block, Block> blueOrchidBud;
    private DeferredHolder<Block, Block> cornflowerBud;
    private DeferredHolder<Block, Block> dandelionBud;
    private DeferredHolder<Block, Block> lilyOfTheValleyBud;
    private DeferredHolder<Block, Block> orangeTulipBud;
    private DeferredHolder<Block, Block> oxeyeDaisyBud;
    private DeferredHolder<Block, Block> pinkTulipBud;
    private DeferredHolder<Block, Block> poppyBud;
    private DeferredHolder<Block, Block> redTulipBud;
    private DeferredHolder<Block, Block> whiteTulipBud;
    private DeferredHolder<Block, Block> witherRoseBud;
    private DeferredHolder<Block, Block> butterflyOrigamiBlack;
    private DeferredHolder<Block, Block> butterflyOrigamiBlue;
    private DeferredHolder<Block, Block> butterflyOrigamiBrown;
    private DeferredHolder<Block, Block> butterflyOrigamiCyan;
    private DeferredHolder<Block, Block> butterflyOrigamiGray;
    private DeferredHolder<Block, Block> butterflyOrigamiGreen;
    private DeferredHolder<Block, Block> butterflyOrigamiLightBlue;
    private DeferredHolder<Block, Block> butterflyOrigamiLightGray;
    private DeferredHolder<Block, Block> butterflyOrigamiLime;
    private DeferredHolder<Block, Block> butterflyOrigamiMagenta;
    private DeferredHolder<Block, Block> butterflyOrigamiOrange;
    private DeferredHolder<Block, Block> butterflyOrigamiPink;
    private DeferredHolder<Block, Block> butterflyOrigamiPurple;
    private DeferredHolder<Block, Block> butterflyOrigamiRed;
    private DeferredHolder<Block, Block> butterflyOrigamiWhite;
    private DeferredHolder<Block, Block> butterflyOrigamiYellow;

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos, EntityType<?> ignoredEntityType) {
        return false;
    }

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos) {
        return false;
    }

    public BlockRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockEntityTypeRegistry blockEntityTypeRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        this.bottledButterflyBlocks = new ArrayList<DeferredHolder<Block, Block>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    DeferredHolder<Block, Block> newBlock = BlockRegistry.this.registerBottledButterfly(i);
                    this.add(newBlock);
                }
            }
        };
        this.bottledCaterpillarBlocks = new ArrayList<DeferredHolder<Block, Block>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    DeferredHolder newBlock = BlockRegistry.this.deferredRegister.register(BlockRegistry.this.getBottledCaterpillarRegistryId(i), BottledCaterpillarBlock::new);
                    this.add(newBlock);
                }
            }
        };
        this.alliumBud = this.deferredRegister.register("bud_allium", () -> new FlowerCropBlock(Blocks.ALLIUM));
        this.azureBluetBud = this.deferredRegister.register("bud_azure_bluet", () -> new FlowerCropBlock(Blocks.AZURE_BLUET));
        this.blueOrchidBud = this.deferredRegister.register("bud_blue_orchid", () -> new FlowerCropBlock(Blocks.BLUE_ORCHID));
        this.cornflowerBud = this.deferredRegister.register("bud_cornflower", () -> new FlowerCropBlock(Blocks.CORNFLOWER));
        this.dandelionBud = this.deferredRegister.register("bud_dandelion", () -> new FlowerCropBlock(Blocks.DANDELION));
        this.lilyOfTheValleyBud = this.deferredRegister.register("bud_lily_of_the_valley", () -> new FlowerCropBlock(Blocks.LILY_OF_THE_VALLEY));
        this.orangeTulipBud = this.deferredRegister.register("bud_orange_tulip", () -> new FlowerCropBlock(Blocks.ORANGE_TULIP));
        this.oxeyeDaisyBud = this.deferredRegister.register("bud_oxeye_daisy", () -> new FlowerCropBlock(Blocks.OXEYE_DAISY));
        this.pinkTulipBud = this.deferredRegister.register("bud_pink_tulip", () -> new FlowerCropBlock(Blocks.PINK_TULIP));
        this.poppyBud = this.deferredRegister.register("bud_poppy", () -> new FlowerCropBlock(Blocks.POPPY));
        this.redTulipBud = this.deferredRegister.register("bud_red_tulip", () -> new FlowerCropBlock(Blocks.RED_TULIP));
        this.whiteTulipBud = this.deferredRegister.register("bud_white_tulip", () -> new FlowerCropBlock(Blocks.WHITE_TULIP));
        this.witherRoseBud = this.deferredRegister.register("bud_wither_rose", () -> new FlowerCropBlock(Blocks.WITHER_ROSE));
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new ButterflyFeederBlock(blockEntityTypeRegistry, menuTypeRegistry));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new ButterflyMicroscopeBlock(itemRegistry, menuTypeRegistry));
        this.butterflyOrigamiBlack = this.registerButterflyOrigami("butterfly_origami_black");
        this.butterflyOrigamiBlue = this.registerButterflyOrigami("butterfly_origami_blue");
        this.butterflyOrigamiBrown = this.registerButterflyOrigami("butterfly_origami_brown");
        this.butterflyOrigamiCyan = this.registerButterflyOrigami("butterfly_origami_cyan");
        this.butterflyOrigamiGray = this.registerButterflyOrigami("butterfly_origami_gray");
        this.butterflyOrigamiGreen = this.registerButterflyOrigami("butterfly_origami_green");
        this.butterflyOrigamiLightBlue = this.registerButterflyOrigami("butterfly_origami_light_blue");
        this.butterflyOrigamiLightGray = this.registerButterflyOrigami("butterfly_origami_light_gray");
        this.butterflyOrigamiLime = this.registerButterflyOrigami("butterfly_origami_lime");
        this.butterflyOrigamiMagenta = this.registerButterflyOrigami("butterfly_origami_magenta");
        this.butterflyOrigamiOrange = this.registerButterflyOrigami("butterfly_origami_orange");
        this.butterflyOrigamiPink = this.registerButterflyOrigami("butterfly_origami_pink");
        this.butterflyOrigamiPurple = this.registerButterflyOrigami("butterfly_origami_purple");
        this.butterflyOrigamiRed = this.registerButterflyOrigami("butterfly_origami_red");
        this.butterflyOrigamiWhite = this.registerButterflyOrigami("butterfly_origami_white");
        this.butterflyOrigamiYellow = this.registerButterflyOrigami("butterfly_origami_yellow");
    }

    public DeferredHolder<Block, Block> getAlliumBud() {
        return this.alliumBud;
    }

    public DeferredHolder<Block, Block> getAzureBluetBud() {
        return this.azureBluetBud;
    }

    public DeferredHolder<Block, Block> getBlueOrchidBud() {
        return this.blueOrchidBud;
    }

    public List<DeferredHolder<Block, Block>> getBottledButterflyBlocks() {
        return this.bottledButterflyBlocks;
    }

    public List<DeferredHolder<Block, Block>> getBottledCaterpillarBlocks() {
        return this.bottledCaterpillarBlocks;
    }

    public DeferredHolder<Block, Block> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public DeferredHolder<Block, Block> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiBlack() {
        return this.butterflyOrigamiBlack;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiBlue() {
        return this.butterflyOrigamiBlue;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiBrown() {
        return this.butterflyOrigamiBrown;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiCyan() {
        return this.butterflyOrigamiCyan;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiGray() {
        return this.butterflyOrigamiGray;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiGreen() {
        return this.butterflyOrigamiGreen;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiLightBlue() {
        return this.butterflyOrigamiLightBlue;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiLightGray() {
        return this.butterflyOrigamiLightGray;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiLime() {
        return this.butterflyOrigamiLime;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiMagenta() {
        return this.butterflyOrigamiMagenta;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiOrange() {
        return this.butterflyOrigamiOrange;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiPink() {
        return this.butterflyOrigamiPink;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiPurple() {
        return this.butterflyOrigamiPurple;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiRed() {
        return this.butterflyOrigamiRed;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiWhite() {
        return this.butterflyOrigamiWhite;
    }

    public DeferredHolder<Block, Block> getButterflyOrigamiYellow() {
        return this.butterflyOrigamiYellow;
    }

    public DeferredHolder<Block, Block> getCornflowerBud() {
        return this.cornflowerBud;
    }

    public DeferredHolder<Block, Block> getDandelionBud() {
        return this.dandelionBud;
    }

    public DeferredHolder<Block, Block> getLilyOfTheValleyBud() {
        return this.lilyOfTheValleyBud;
    }

    public DeferredHolder<Block, Block> getOrangeTulipBud() {
        return this.orangeTulipBud;
    }

    public DeferredHolder<Block, Block> getOxeyeDaisyBud() {
        return this.oxeyeDaisyBud;
    }

    public DeferredHolder<Block, Block> getPinkTulipBud() {
        return this.pinkTulipBud;
    }

    public DeferredHolder<Block, Block> getPoppyBud() {
        return this.poppyBud;
    }

    public DeferredHolder<Block, Block> getRedTulipBud() {
        return this.redTulipBud;
    }

    public DeferredHolder<Block, Block> getWhiteTulipBud() {
        return this.whiteTulipBud;
    }

    public DeferredHolder<Block, Block> getWitherRoseBud() {
        return this.witherRoseBud;
    }

    private String getBottledButterflyRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    private String getBottledCaterpillarRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    private DeferredHolder<Block, Block> registerBottledButterfly(int butterflyIndex) {
        String registryId = this.getBottledButterflyRegistryId(butterflyIndex);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f);
        if (registryId.equals("bottled_butterfly_light")) {
            properties.lightLevel(blockState -> 15);
        }
        return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(properties));
    }

    private DeferredHolder<Block, Block> registerButterflyOrigami(String id) {
        return this.deferredRegister.register(id, ButterflyOrigamiBlock::new);
    }
}

