/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.IceButterfly;
import com.bokmcdok.butterflies.world.entity.animal.LavaMoth;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EntityTypeRegistry {
    private final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> butterflyScroll;
    private List<DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>>> butterflies;
    private List<DeferredHolder<EntityType<?>, EntityType<Caterpillar>>> caterpillars;
    private List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> chrysalises;
    private List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> butterflyEggs;
    private DeferredHolder<EntityType<?>, EntityType<IronGolem>> butterflyGolem;

    public EntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry) {
        this.blockRegistry = blockRegistry;
        this.butterflyScroll = this.deferredRegister.register("butterfly_scroll", () -> EntityType.Builder.of(ButterflyScroll::create, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).build("butterfly_scroll"));
        this.butterflies = new ArrayList<DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterfly(i));
                }
            }
        };
        this.caterpillars = new ArrayList<DeferredHolder<EntityType<?>, EntityType<Caterpillar>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.chrysalises = new ArrayList<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerChrysalis(i));
                }
            }
        };
        this.butterflyEggs = new ArrayList<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(EntityTypeRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyGolem = this.registerButterflyGolem();
    }

    public List<DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>>> getButterflies() {
        return this.butterflies;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> getButterflyScroll() {
        return this.butterflyScroll;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<Caterpillar>>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<EntityType<?>, EntityType<Chrysalis>>> getChrysalises() {
        return this.chrysalises;
    }

    public DeferredHolder<EntityType<?>, EntityType<IronGolem>> getButterflyGolem() {
        return this.butterflyGolem;
    }

    private Butterfly createButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new Butterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createIceButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new IceButterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createLavaMoth(EntityType<? extends Butterfly> entityType, Level level) {
        return new LavaMoth(this.blockRegistry, entityType, level);
    }

    private DeferredHolder<EntityType<?>, EntityType<? extends Butterfly>> registerButterfly(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        if (registryId.equals("ice")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createIceButterfly, (MobCategory)MobCategory.CREATURE).sized(0.3f, 0.2f).clientTrackingRange(10).build(Butterfly.getRegistryId(butterflyIndex)));
        }
        if (registryId.equals("lava")) {
            return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createLavaMoth, (MobCategory)MobCategory.CREATURE).sized(0.3f, 0.2f).clientTrackingRange(10).build(Butterfly.getRegistryId(butterflyIndex)));
        }
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.of(this::createButterfly, (MobCategory)MobCategory.CREATURE).sized(0.3f, 0.2f).clientTrackingRange(10).build(Butterfly.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<EntityType<?>, EntityType<Caterpillar>> registerCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(Caterpillar.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(Caterpillar::new, (MobCategory)MobCategory.CREATURE).sized(0.1f, 0.1f).build(Caterpillar.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<EntityType<?>, EntityType<Chrysalis>> registerChrysalis(int butterflyIndex) {
        return this.deferredRegister.register(Chrysalis.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(Chrysalis::new, (MobCategory)MobCategory.CREATURE).sized(0.1f, 0.1f).build(Chrysalis.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<EntityType<?>, EntityType<ButterflyEgg>> registerButterflyEgg(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyEgg.getRegistryId(butterflyIndex), () -> EntityType.Builder.of(ButterflyEgg::new, (MobCategory)MobCategory.CREATURE).sized(0.1f, 0.1f).build(ButterflyEgg.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<EntityType<?>, EntityType<IronGolem>> registerButterflyGolem() {
        return this.deferredRegister.register("butterfly_golem", () -> EntityType.Builder.of(IronGolem::new, (MobCategory)MobCategory.MISC).sized(1.4f, 2.7f).clientTrackingRange(10).build("butterfly_golem"));
    }
}

