/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class DirectionalCreature
extends Animal {
    protected static final EntityDataAccessor<Direction> DATA_DIRECTION = SynchedEntityData.defineId(DirectionalCreature.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    protected static final String DIRECTION = "direction";
    private ButterflyData data = null;
    private ResourceLocation texture;

    public static boolean checkDirectionalSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        String descriptionId = entityType.getDescriptionId();
        String[] components = descriptionId.split("\\.");
        for (Direction direction : Direction.values()) {
            BlockPos surfacePosition = blockPos;
            if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                surfacePosition = surfacePosition.relative(direction);
            }
            if (!level.hasChunkAt(surfacePosition)) continue;
            ButterflyData data = ButterflyData.getEntry(new ResourceLocation("butterflies", components[2]));
            if (data == null) {
                return level.getBlockState(surfacePosition).is(BlockTags.LEAVES);
            }
            if (!data.isValidLandingBlock(level.getBlockState(surfacePosition))) continue;
            return true;
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString(DIRECTION, ((Direction)this.entityData.get(DATA_DIRECTION)).getName());
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.setPersistenceRequired();
        }
        if (!levelAccessor.hasChunkAt(this.getSurfaceBlockPos())) {
            this.setSurfaceDirection(Direction.DOWN);
        }
        if (this.getIsReleased() && levelAccessor.hasChunkAt(this.getSurfaceBlockPos()) && !this.getData().isValidLandingBlock(levelAccessor.getBlockState(this.getSurfaceBlockPos()))) {
            for (Direction direction : Direction.values()) {
                BlockPos surfacePosition = this.blockPosition().relative(direction);
                if (!levelAccessor.hasChunkAt(surfacePosition) || !this.getData().isValidLandingBlock(levelAccessor.getBlockState(surfacePosition))) continue;
                this.setSurfaceDirection(direction);
                Vec3 position = this.position();
                double x = position.x();
                double y = position.y();
                double z = position.z();
                switch (direction) {
                    case DOWN: {
                        y = Math.floor(position.y());
                        break;
                    }
                    case UP: {
                        y = Math.floor(position.y()) + 1.0;
                        break;
                    }
                    case NORTH: {
                        z = Math.floor(position.z());
                        break;
                    }
                    case SOUTH: {
                        z = Math.floor(position.z()) + 1.0;
                        break;
                    }
                    case WEST: {
                        x = Math.floor(position.x());
                        break;
                    }
                    case EAST: {
                        x = Math.floor(position.x()) + 1.0;
                    }
                }
                this.moveTo(x, y, z, 0.0f, 0.0f);
                break;
            }
        }
        return super.finalizeSpawn(levelAccessor, difficulty, spawnType, groupData, compoundTag);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    @NotNull
    public Direction getSurfaceDirection() {
        return (Direction)this.entityData.get(DATA_DIRECTION);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        String name;
        Direction direction;
        super.readAdditionalSaveData(tag);
        if (tag.contains(DIRECTION) && (direction = Direction.byName((String)(name = tag.getString(DIRECTION)))) != null) {
            this.entityData.set(DATA_DIRECTION, (Object)direction);
        }
    }

    public void setSurfaceDirection(Direction direction) {
        this.entityData.set(DATA_DIRECTION, (Object)direction);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.setAge(this.getAge() + 1);
    }

    protected DirectionalCreature(EntityType<? extends DirectionalCreature> entityType, Level level) {
        super(entityType, level);
    }

    protected void setTexture(String texture) {
        this.texture = new ResourceLocation("butterflies", texture);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_DIRECTION, (Object)Direction.DOWN);
    }

    protected ButterflyData getData() {
        if (this.data == null) {
            this.data = ButterflyData.getButterflyDataForEntity((LivingEntity)this);
        }
        return this.data;
    }

    protected boolean getIsReleased() {
        return true;
    }

    protected BlockPos getSurfaceBlockPos() {
        return switch (this.getSurfaceDirection().getAxisDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.AxisDirection.POSITIVE -> this.blockPosition();
            case Direction.AxisDirection.NEGATIVE -> this.blockPosition().relative(this.getSurfaceDirection());
        };
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

