/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottledButterflyItem
extends BlockItem
implements ButterflyContainerItem {
    private static final String NAME = "block.butterflies.bottled_butterfly";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public BottledButterflyItem(DeferredHolder<Block, Block> block, int butterflyIndex) {
        super((Block)block.get(), new Item.Properties().stacksTo(1));
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.release_butterfly");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        return Component.translatable((String)NAME);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation entity = this.getButterflyEntity(stack);
        if (entity != null) {
            Vec3 lookAngle = player.getLookAngle();
            BlockPos positionToSpawn = player.blockPosition().offset((int)lookAngle.x, (int)lookAngle.y + 1, (int)lookAngle.z);
            Butterfly.spawn(player.level(), entity, positionToSpawn, false);
        }
        player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        return InteractionResultHolder.success((Object)stack);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        ItemStack stack;
        ResourceLocation entity;
        Player player;
        InteractionResult result = super.place(context);
        if (result == InteractionResult.CONSUME && (player = context.getPlayer()) != null && (entity = this.getButterflyEntity(stack = player.getItemInHand(context.getHand()))) != null) {
            BlockPos position = context.getClickedPos();
            Butterfly.spawn(player.level(), entity, position, true);
        }
        return result;
    }
}

