/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyNetItem
extends Item
implements ButterflyContainerItem {
    public static final String EMPTY_NAME = "butterfly_net";
    private static final String NAME = "item.butterflies.butterfly_net";
    private final ItemRegistry itemRegistry;
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_net_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public ButterflyNetItem(ItemRegistry itemRegistry, int butterflyIndex) {
        super(new Item.Properties().stacksTo(1));
        this.itemRegistry = itemRegistry;
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        String localisation = "tooltip.butterflies.release_butterfly";
        if (this.butterflyIndex < 0) {
            localisation = "tooltip.butterflies.butterfly_net";
        }
        MutableComponent newComponent = Component.translatable((String)localisation);
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this.itemRegistry.getEmptyButterflyNet().get());
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        return Component.translatable((String)NAME);
    }

    public boolean hasCraftingRemainingItem() {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Butterfly butterfly;
        DeferredHolder<Item, Item> item;
        if (entity instanceof Butterfly && (item = this.itemRegistry.getButterflyNetFromIndex((butterfly = (Butterfly)entity).getButterflyIndex())) != null) {
            ItemStack newStack = new ItemStack((ItemLike)item.get(), 1);
            if (item != this.itemRegistry.getBurntButterflyNet()) {
                entity.discard();
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, newStack);
            player.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation entity = this.getButterflyEntity(stack);
        if (entity != null) {
            Vec3 lookAngle = player.getLookAngle();
            BlockPos positionToSpawn = player.blockPosition().offset((int)lookAngle.x, (int)lookAngle.y + 1, (int)lookAngle.z);
            Butterfly.spawn(player.level(), entity, positionToSpawn, false);
            ItemStack newStack = new ItemStack((ItemLike)this.itemRegistry.getEmptyButterflyNet().get(), 1);
            player.setItemInHand(hand, newStack);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }
}

