/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.lifecycle;

import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyFeederScreen;
import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyMicroscopeScreen;
import com.bokmcdok.butterflies.event.network.NetworkEventListener;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import java.util.Arrays;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class LifecycleEventListener {
    private final ItemRegistry itemRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public LifecycleEventListener(IEventBus modEventBus, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        modEventBus.register((Object)this);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        this.itemRegistry = itemRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        NetworkEventListener.BUTTERFLY_NETWORK_CHANNEL.addListener(NetworkEventListener::onButterflyCollectionPayload);
        int monarchIndex = Arrays.asList(ButterflySpeciesList.SPECIES).indexOf("monarch");
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.itemRegistry.getBottledButterflies().get(monarchIndex).get()}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)this.menuTypeRegistry.getButterflyFeederMenu().get()), ButterflyFeederScreen::new));
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)this.menuTypeRegistry.getButterflyMicroscopeMenu().get()), ButterflyMicroscopeScreen::new));
    }
}

