/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.lucraft.world.util;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thecrafterl.mods.lucraft.world.blocks.LucraftWorldBlocks;
import thecrafterl.mods.lucraft.world.fluids.LucraftWorldFluids;
import thecrafterl.mods.lucraft.world.items.LucraftWorldItems;
import thecrafterl.mods.lucraft.world.util.ThermalExpansionHelper;

public class RecipeHelper {
    public static void addStorageBlockCrafting(String oreDict, int meta) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)LucraftWorldBlocks.storage, 1, meta), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingot" + oreDict}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)LucraftWorldItems.ingot, 9, meta), new Object[]{"X", Character.valueOf('X'), new ItemStack((Block)LucraftWorldBlocks.storage, 1, meta)}));
    }

    public static void addStorageItemCrafting(String oreDict, ItemStack ingot, int meta) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)LucraftWorldItems.nugget, 9, meta), new Object[]{"X", Character.valueOf('X'), "ingot" + oreDict}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "nugget" + oreDict}));
    }

    public static void addAlloyRecipe(ItemStack primaryItem, ItemStack secondaryItem, ItemStack output, int energy) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryItem, secondaryItem, output);
    }

    public static void addOreDictAlloyRecipe(String primaryItem, int primaryItemAmount, String secondaryItem, int secondaryItemAmount, String output, int outputAmount, int energy, String name) {
        ArrayList primaryItemList = OreDictionary.getOres((String)primaryItem);
        ArrayList secondaryItemList = OreDictionary.getOres((String)secondaryItem);
        ArrayList outputList = OreDictionary.getOres((String)output);
        for (int i = 0; i < primaryItemList.size(); ++i) {
            for (int j = 0; j < secondaryItemList.size(); ++j) {
                for (int k = 0; k < outputList.size(); ++k) {
                    ItemStack primaryItemStack = (ItemStack)primaryItemList.get(i);
                    primaryItemStack = primaryItemStack.func_77946_l();
                    primaryItemStack.field_77994_a = primaryItemAmount;
                    ItemStack secondaryItemStack = (ItemStack)secondaryItemList.get(j);
                    secondaryItemStack = secondaryItemStack.func_77946_l();
                    secondaryItemStack.field_77994_a = secondaryItemAmount;
                    ItemStack outputItemStack = (ItemStack)outputList.get(k);
                    outputItemStack = outputItemStack.func_77946_l();
                    outputItemStack.field_77994_a = outputAmount;
                    RecipeHelper.addAlloyRecipe(primaryItemStack, secondaryItemStack, outputItemStack, energy);
                    RecipeHelper.addAlloySmelterRecipe(name, energy, primaryItemStack, secondaryItemStack, outputItemStack);
                }
            }
        }
    }

    public static void addAlloySmelterRecipe(String name, int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack output) {
        StringBuilder toSend = new StringBuilder();
        toSend.append("<recipeGroup name=\"LucraftWorld\">");
        toSend.append("<recipe name=\"" + name + "\" energyCost=\"" + energy + "\">");
        toSend.append("<input>");
        RecipeHelper.appendItemStack(toSend, primaryInput);
        RecipeHelper.appendItemStack(toSend, secondaryInput);
        toSend.append("</input>");
        toSend.append("<output>");
        RecipeHelper.appendItemStack(toSend, output);
        toSend.append("</output>");
        toSend.append("</recipe>");
        toSend.append("</recipeGroup>");
        FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:alloysmelter", (String)toSend.toString());
    }

    private static void appendItemStack(StringBuilder sb, ItemStack stack) {
        if (stack != null) {
            String[] itemName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()).split(":");
            sb.append("<itemStack modID=\"" + itemName[0] + "\" itemName=\"" + itemName[1] + "\" itemMeta=\"" + stack.func_77960_j() + "\" number=\"" + stack.field_77994_a + "\" />");
        }
    }

    public static void registerOreDictionary(int meta, String name) {
        OreDictionary.registerOre((String)("block" + name), (ItemStack)new ItemStack((Block)LucraftWorldBlocks.storage, 1, meta));
        OreDictionary.registerOre((String)("ore" + name), (ItemStack)new ItemStack((Block)LucraftWorldBlocks.ore, 1, meta));
        OreDictionary.registerOre((String)("ingot" + name), (ItemStack)new ItemStack((Item)LucraftWorldItems.ingot, 1, meta));
        OreDictionary.registerOre((String)("dust" + name), (ItemStack)new ItemStack((Item)LucraftWorldItems.dust, 1, meta));
    }

    public static void machineRecipes(String name) {
        int j;
        int i;
        ArrayList oreList = OreDictionary.getOres((String)("ore" + name));
        ArrayList dustList = OreDictionary.getOres((String)("dust" + name));
        ArrayList ingotList = OreDictionary.getOres((String)("ingot" + name));
        ArrayList blockList = OreDictionary.getOres((String)("block" + name));
        for (i = 0; i < oreList.size(); ++i) {
            for (j = 0; j < ingotList.size(); ++j) {
                for (int k = 0; k < dustList.size(); ++k) {
                    for (int l = 0; l < blockList.size(); ++l) {
                        ItemStack oreStack = (ItemStack)oreList.get(i);
                        oreStack = oreStack.func_77946_l();
                        oreStack.field_77994_a = 1;
                        ItemStack ingotStack = (ItemStack)ingotList.get(j);
                        ingotStack = ingotStack.func_77946_l();
                        ingotStack.field_77994_a = 1;
                        ItemStack dustStack = (ItemStack)dustList.get(k);
                        dustStack = dustStack.func_77946_l();
                        dustStack.field_77994_a = 2;
                        ItemStack dustStack2 = (ItemStack)dustList.get(k);
                        dustStack2 = dustStack2.func_77946_l();
                        dustStack2.field_77994_a = 1;
                        ItemStack dustStack3 = (ItemStack)dustList.get(k);
                        dustStack3 = dustStack3.func_77946_l();
                        dustStack3.field_77994_a = 9;
                        ItemStack blockStack = (ItemStack)blockList.get(l);
                        blockStack = blockStack.func_77946_l();
                        blockStack.field_77994_a = 1;
                        ThermalExpansionHelper.addPulverizerRecipe(2400, oreStack, dustStack);
                        RecipeHelper.addSAGMillRecipe(name, 2400, oreStack, dustStack);
                        ThermalExpansionHelper.addPulverizerRecipe(2400, ingotStack, dustStack2);
                        RecipeHelper.addSAGMillRecipe(name, 2400, ingotStack, dustStack2);
                        ThermalExpansionHelper.addPulverizerRecipe(2400, blockStack, dustStack3);
                        RecipeHelper.addSAGMillRecipe(name, 2400, blockStack, dustStack3);
                    }
                }
            }
        }
        for (i = 0; i < oreList.size(); ++i) {
            for (j = 0; j < ingotList.size(); ++j) {
                ItemStack oreStack = (ItemStack)oreList.get(i);
                oreStack = oreStack.func_77946_l();
                oreStack.field_77994_a = 1;
                ItemStack ingotStack = (ItemStack)ingotList.get(j);
                ingotStack = ingotStack.func_77946_l();
                ingotStack.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)oreStack, (ItemStack)ingotStack, (float)0.5f);
            }
        }
        for (i = 0; i < dustList.size(); ++i) {
            for (j = 0; j < ingotList.size(); ++j) {
                ItemStack dustStack = (ItemStack)dustList.get(i);
                dustStack = dustStack.func_77946_l();
                dustStack.field_77994_a = 1;
                ItemStack ingotStack = (ItemStack)ingotList.get(j);
                ingotStack = ingotStack.func_77946_l();
                ingotStack.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dustStack, (ItemStack)ingotStack, (float)0.5f);
                ThermalExpansionHelper.addPulverizerRecipe(2400, ingotStack, dustStack);
            }
        }
    }

    public static void addSAGMillRecipe(String name, int energy, ItemStack primaryInput, ItemStack output) {
        StringBuilder toSend = new StringBuilder();
        toSend.append("<recipeGroup name=\"LucraftWorld\">");
        toSend.append("<recipe name=\"" + name + "\" energyCost=\"" + energy + "\">");
        toSend.append("<input>");
        RecipeHelper.appendItemStack(toSend, primaryInput);
        toSend.append("</input>");
        toSend.append("<output>");
        RecipeHelper.appendItemStack(toSend, output);
        toSend.append("</output>");
        toSend.append("</recipe>");
        toSend.append("</recipeGroup>");
        FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:sagmill", (String)toSend.toString());
    }

    public static void addCrucibleRecipe(String name, int energy, int energyPerBlock) {
        int i;
        ArrayList ingotList = OreDictionary.getOres((String)("ingot" + name));
        ArrayList blockList = OreDictionary.getOres((String)("block" + name));
        for (i = 0; i < ingotList.size(); ++i) {
            ItemStack ingotStack = (ItemStack)ingotList.get(i);
            ingotStack = ingotStack.func_77946_l();
            ingotStack.field_77994_a = 1;
            ThermalExpansionHelper.addCrucibleRecipe(energy, ingotStack, new FluidStack(FluidRegistry.getFluid((String)name.toLowerCase()), 250));
        }
        for (i = 0; i < blockList.size(); ++i) {
            ItemStack blockStack = (ItemStack)blockList.get(i);
            blockStack = blockStack.func_77946_l();
            blockStack.field_77994_a = 1;
            ThermalExpansionHelper.addCrucibleRecipe(energyPerBlock, blockStack, new FluidStack(FluidRegistry.getFluid((String)name.toLowerCase()), 2250));
        }
    }

    public static void addCrucibleRecipe(String name) {
        RecipeHelper.addCrucibleRecipe(name, 8000, 72000);
    }

    public static void addCastRecipe(String materialname, String fluidName) {
        ArrayList ingotList = OreDictionary.getOres((String)("ingot" + materialname));
        ArrayList blockList = OreDictionary.getOres((String)("block" + materialname));
        Fluid fluid = FluidRegistry.getFluid((String)fluidName.toLowerCase());
        if (fluid != null) {
            int i;
            for (i = 0; i < ingotList.size(); ++i) {
                ItemStack ingotStack = (ItemStack)ingotList.get(i);
                ingotStack = ingotStack.func_77946_l();
                ingotStack.field_77994_a = 1;
                ThermalExpansionHelper.addTransposerFill(1000, new ItemStack((Item)LucraftWorldFluids.ingotCast), ingotStack, new FluidStack(fluid, 250), false);
            }
            for (i = 0; i < blockList.size(); ++i) {
                ItemStack blockStack = (ItemStack)blockList.get(i);
                blockStack = blockStack.func_77946_l();
                blockStack.field_77994_a = 1;
                ThermalExpansionHelper.addTransposerFill(9000, new ItemStack((Block)LucraftWorldFluids.blockCast), blockStack, new FluidStack(fluid, 2250), false);
            }
        }
    }

    public static void addCastRecipe(String name) {
        RecipeHelper.addCastRecipe(name, name);
    }

    protected static void sendInterModMessage(String to, String type, NBTTagCompound message) {
        FMLInterModComms.sendMessage((String)to, (String)type, (NBTTagCompound)message);
    }

    public static void addOreToMiningLaserFocus(ItemStack stack, int color) {
        NBTTagCompound laserOreMsg = new NBTTagCompound();
        stack.func_77955_b(laserOreMsg);
        laserOreMsg.func_74768_a("value", color);
        RecipeHelper.sendInterModMessage("MineFactoryReloaded", "registerLaserOre", laserOreMsg);
    }

    public static void addGrinderRecipe(String name, int turns) {
        ArrayList oreList = OreDictionary.getOres((String)("ore" + name));
        ArrayList dustList = OreDictionary.getOres((String)("dust" + name));
        for (int i = 0; i < oreList.size(); ++i) {
            for (int j = 0; j < dustList.size(); ++j) {
                ItemStack oreStack = (ItemStack)oreList.get(i);
                oreStack = oreStack.func_77946_l();
                oreStack.field_77994_a = 1;
                ItemStack dustStack = (ItemStack)dustList.get(j);
                dustStack = dustStack.func_77946_l();
                dustStack.field_77994_a = 1;
                NBTTagCompound msg = new NBTTagCompound();
                NBTTagCompound in = new NBTTagCompound();
                NBTTagCompound out = new NBTTagCompound();
                oreStack.func_77955_b(in);
                dustStack.func_77955_b(out);
                msg.func_74782_a("in", (NBTBase)in);
                msg.func_74782_a("out", (NBTBase)out);
                msg.func_74768_a("turns", turns);
                RecipeHelper.sendInterModMessage("appliedenergistics2", "add-grindable", msg);
            }
        }
    }
}

