/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.custom;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.entity.interfaces.DancesToJukebox;
import org.jetbrains.annotations.Nullable;

public class DancingEntity
extends Animal
implements DancesToJukebox {
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(DancingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> JX = SynchedEntityData.m_135353_(DancingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JY = SynchedEntityData.m_135353_(DancingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JZ = SynchedEntityData.m_135353_(DancingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private BlockPos jukeboxPosition;
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener;
    private final VibrationSystem.User vibrationUser = new VibrationUser();

    public DancingEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener(this.vibrationUser.m_280010_(), GameEvent.f_238690_.m_157827_()));
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            pListenerConsumer.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCING, (Object)false);
        this.f_19804_.m_135372_(JX, (Object)0);
        this.f_19804_.m_135372_(JY, (Object)0);
        this.f_19804_.m_135372_(JZ, (Object)0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getJukeboxPos() != null) {
            if (!this.getJukeboxPos().m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_())) {
                this.setDancing(false);
            } else {
                this.setDancing(true);
            }
        }
    }

    @Override
    public void setJukeboxPos(BlockPos pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(JX, null);
            this.f_19804_.m_135381_(JY, null);
            this.f_19804_.m_135381_(JZ, null);
        } else {
            this.f_19804_.m_135381_(JX, (Object)((int)pos.m_252807_().f_82479_));
            this.f_19804_.m_135381_(JY, (Object)((int)pos.m_252807_().f_82480_));
            this.f_19804_.m_135381_(JZ, (Object)((int)pos.m_252807_().f_82481_));
        }
    }

    public BlockPos getJukeboxPos() {
        if (this.f_19804_.m_135370_(JX) == null) {
            return null;
        }
        BlockPos pos = new BlockPos((Integer)this.f_19804_.m_135370_(JX) - 1, ((Integer)this.f_19804_.m_135370_(JY)).intValue(), ((Integer)this.f_19804_.m_135370_(JZ)).intValue());
        return pos;
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    @Override
    public void setDancing(boolean dancing) {
        this.f_19804_.m_135381_(DANCING, (Object)dancing);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Dancing", this.isDancing());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDancing(compound.m_128471_("Dancing"));
    }

    public void setJukeboxPlaying(BlockPos jukepos, boolean playing) {
        if (playing) {
            if (!this.isDancing()) {
                this.setJukeboxPos(jukepos);
                this.setDancing(true);
            }
        } else {
            this.setJukeboxPos(null);
            this.setDancing(false);
        }
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int VIBRATION_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)DancingEntity.this, DancingEntity.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
            return true;
        }

        public void m_280271_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity1, float v) {
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215855_;
        }
    }

    class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource pListenerSource, int pListenerRadius) {
            this.listenerSource = pListenerSource;
            this.listenerRadius = pListenerRadius;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(ServerLevel pLevel, GameEvent pGameEvent, GameEvent.Context pContext, Vec3 pPos) {
            if (pGameEvent == GameEvent.f_238690_) {
                DancingEntity.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pPos), true);
                return true;
            }
            if (pGameEvent == GameEvent.f_238649_) {
                DancingEntity.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pPos), false);
                return true;
            }
            return false;
        }
    }
}

