/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.block.custom.AnemoneBlock;
import net.thevaliantsquidward.rainbowreef.entity.custom.LocateNemGoal;
import net.thevaliantsquidward.rainbowreef.entity.custom.MoveToNemGoal;
import net.thevaliantsquidward.rainbowreef.entity.custom.RestInNemGoal;
import net.thevaliantsquidward.rainbowreef.entity.custom.base.VariantSchoolingFish;

public class NemHoster
extends VariantSchoolingFish {
    private static final EntityDataAccessor<BlockPos> HOME = SynchedEntityData.m_135353_(NemHoster.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> HASNEM = SynchedEntityData.m_135353_(NemHoster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int nemSearchCooldown;

    public NemHoster(EntityType<? extends VariantSchoolingFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 60, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 4);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(HASNEM, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LocateNemGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveToNemGoal(this, 1.0, 16, 1));
        this.f_21345_.m_25352_(3, (Goal)new RestInNemGoal(this, 3.0, 600, 400, true));
    }

    @Override
    public void m_8119_() {
        if (this.getNemPos() != null) {
            if (!(this.m_9236_().m_8055_(new BlockPos((Vec3i)this.getNemPos())).m_60734_() instanceof AnemoneBlock)) {
                this.setHasNem(false);
                this.setNemPos(null);
            } else {
                this.setHasNem(true);
            }
        }
        if (this.nemSearchCooldown > 0) {
            --this.nemSearchCooldown;
        }
        super.m_8119_();
    }

    public void setNemPos(BlockPos pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(HASNEM, (Object)false);
            this.f_19804_.m_135381_(HOME, null);
        } else {
            this.f_19804_.m_135381_(HOME, (Object)pos);
        }
    }

    public BlockPos getNemPos() {
        if (this.f_19804_.m_135370_(HOME) == null) {
            return null;
        }
        BlockPos pos = (BlockPos)this.f_19804_.m_135370_(HOME);
        return pos;
    }

    public boolean hasNem() {
        return (Boolean)this.f_19804_.m_135370_(HASNEM);
    }

    public void setHasNem(boolean has) {
        this.f_19804_.m_135381_(HASNEM, (Object)has);
    }

    public boolean canSee(BlockPos pos) {
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (vec31.m_82554_(vec3) > 20.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }
}

