/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.custom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.entity.ModEntities;
import net.thevaliantsquidward.rainbowreef.entity.custom.base.VariantSchoolingFish;
import net.thevaliantsquidward.rainbowreef.entity.goalz.CustomizableRandomSwimGoal;
import net.thevaliantsquidward.rainbowreef.entity.interfaces.VariantEntity;
import net.thevaliantsquidward.rainbowreef.item.ModItems;
import net.thevaliantsquidward.rainbowreef.util.MathHelpers;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RayEntity
extends VariantSchoolingFish
implements GeoEntity,
Bucketable,
VariantEntity {
    public Vec3 rightRefPoint;
    public Vec3 rightRefOffset = new Vec3(1.0, 0.0, 0.0);
    public Vec3 leftRefPoint;
    public Vec3 leftRefOffset = new Vec3(-1.0, 0.0, 0.0);
    public Vec3 upRefPoint;
    public Vec3 upRefOffset = new Vec3(0.0, -1.0, 0.0);
    public Vec3 downRefPoint;
    public Vec3 downRefOffset = new Vec3(0.0, 1.0, 0.0);
    public Vec3 nosePoint;
    public Vec3 tail0Point;
    public Vec3 tail1Point;
    public Vec3 tail2Point;
    public Vec3 tail3Point;
    public Vec3 tail4Point;
    public Vec3 tail5Point;
    public Vec3 tail6Point;
    public Vec3 noseOffset = new Vec3(0.0, 0.0, -0.47);
    public Vec3 tail0Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail1Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail2Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail3Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail4Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail5Offset = new Vec3(0.0, 0.0, 0.47);
    public Vec3 tail6Offset = new Vec3(0.0, 0.0, 0.47);
    public double bodyPitch = 0.0;
    public double currentBodyPitch = 0.0;
    public double tail1Angle;
    public double tail2Angle;
    public double tail3Angle;
    public double tail4Angle;
    public double tail5Angle;
    public double currentTail1Yaw = 3.1415927410125732;
    public double currentTail2Yaw = 3.1415927410125732;
    public double currentTail3Yaw = 3.1415927410125732;
    public double currentTail4Yaw = 3.1415927410125732;
    public double currentTail5Yaw = 3.1415927410125732;
    public double currentTail1Pitch = 0.0;
    public double currentTail2Pitch = 0.0;
    public double currentTail3Pitch = 0.0;
    public double currentTail4Pitch = 0.0;
    public double currentTail5Pitch = 0.0;
    public double tail1Pitch;
    public double tail2Pitch;
    public double tail3Pitch;
    public double tail4Pitch;
    public double tail5Pitch;
    public int animTime;
    public double animSpeed = 1.0;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(RayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(RayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "ornate";
            case 2 -> "cownose";
            default -> "spotted";
        };
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    @Override
    public int getMaxSchoolSize() {
        return 4;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SPOTTED_EAGLE_RAY_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float variantChange = this.m_217043_().m_188501_();
        if (!(variantChange <= 0.33f)) {
            if (variantChange <= 0.66f) {
                this.setVariant(2);
            } else if (variantChange <= 0.99f) {
                this.setVariant(1);
            } else {
                this.setVariant(0);
            }
        }
        if (reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.NATURAL) {
            float schoolsize = this.m_217043_().m_188501_();
            int schoolcount = (int)((float)this.getMaxSchoolSize() * schoolsize);
            if (schoolcount > 0 && !this.m_9236_().m_5776_()) {
                for (int i = 0; i < schoolcount; ++i) {
                    RayEntity urine = new RayEntity((EntityType<? extends VariantSchoolingFish>)((EntityType)ModEntities.RAY.get()), this.m_9236_());
                    urine.setVariant(this.getVariant());
                    urine.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    urine.startFollowing(this);
                    this.m_9236_().m_7967_((Entity)urine);
                }
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public RayEntity(EntityType<? extends VariantSchoolingFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 360, 2, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 4);
        this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-this.m_146908_()));
        this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-this.m_146908_()));
        this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-this.m_146908_()));
        this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-this.m_146908_()));
        this.nosePoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.noseOffset), Double.valueOf(-this.m_146908_()));
        this.tail0Point = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.tail0Offset), Double.valueOf(-this.m_146908_()));
        this.tail1Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail0Point, this.tail0Point.m_82546_(this.tail1Offset), Double.valueOf(-this.m_146908_()));
        this.tail2Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail1Point, this.tail1Point.m_82546_(this.tail2Offset), Double.valueOf(-this.m_146908_()));
        this.tail3Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail2Point, this.tail2Point.m_82546_(this.tail3Offset), Double.valueOf(-this.m_146908_()));
        this.tail4Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail3Point, this.tail3Point.m_82546_(this.tail4Offset), Double.valueOf(-this.m_146908_()));
        this.tail5Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail4Point, this.tail4Point.m_82546_(this.tail5Offset), Double.valueOf(-this.m_146908_()));
        this.tail6Point = MathHelpers.rotateAroundCenterFlatDeg(this.tail5Point, this.tail5Point.m_82546_(this.tail6Offset), Double.valueOf(-this.m_146908_()));
    }

    @Override
    public void m_8119_() {
        if (this.m_20069_()) {
            this.tail1Angle = MathHelpers.angleClamp(MathHelpers.getAngleForLinkTopDownFlat(this.tail1Point, this.tail0Point, this.tail2Point, this.leftRefPoint, this.rightRefPoint), 2.35619455575943);
            this.tail2Angle = MathHelpers.angleClamp(MathHelpers.getAngleForLinkTopDownFlat(this.tail2Point, this.tail1Point, this.tail3Point, this.leftRefPoint, this.rightRefPoint), 2.35619455575943);
            this.tail3Angle = MathHelpers.angleClamp(MathHelpers.getAngleForLinkTopDownFlat(this.tail3Point, this.tail2Point, this.tail4Point, this.leftRefPoint, this.rightRefPoint), 2.35619455575943);
            this.tail4Angle = MathHelpers.angleClamp(MathHelpers.getAngleForLinkTopDownFlat(this.tail4Point, this.tail3Point, this.tail5Point, this.leftRefPoint, this.rightRefPoint), 2.35619455575943);
            this.tail5Angle = MathHelpers.angleClamp(MathHelpers.getAngleForLinkTopDownFlat(this.tail5Point, this.tail4Point, this.tail6Point, this.leftRefPoint, this.rightRefPoint), 2.35619455575943);
            this.bodyPitch = (float)MathHelpers.angleFromYdiff(this.nosePoint, this.m_20182_(), this.tail0Point);
            this.tail1Pitch = (float)MathHelpers.angleFromYdiff(this.nosePoint, this.m_20182_(), this.tail0Point);
            this.tail2Pitch = (float)(3.1415927410125732 * MathHelpers.angleFromYdiff(this.tail0Point, this.tail1Point, this.tail2Point));
            this.tail3Pitch = (float)(3.1415927410125732 * MathHelpers.angleFromYdiff(this.tail1Point, this.tail2Point, this.tail3Point));
            this.tail4Pitch = (float)(3.1415927410125732 * MathHelpers.angleFromYdiff(this.tail2Point, this.tail3Point, this.tail4Point));
            this.tail5Pitch = (float)(3.1415927410125732 * MathHelpers.angleFromYdiff(this.tail3Point, this.tail4Point, this.tail5Point));
            this.nosePoint = MathHelpers.rotateAroundCenter3dDeg(this.m_20182_(), this.m_20182_().m_82546_(this.noseOffset), -this.m_146908_(), -this.m_146909_());
            this.tail0Point = MathHelpers.rotateAroundCenter3dDeg(this.m_20182_(), this.m_20182_().m_82546_(this.tail0Offset), -this.m_146908_(), -this.m_146909_());
            this.tail1Point = MathHelpers.rotateAroundCenter3dDeg(this.tail0Point, this.tail0Point.m_82546_(this.tail1Offset), -MathHelpers.angleTo((Vec3)this.tail0Point, (Vec3)this.tail1Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail0Point, (Vec3)this.tail1Point).f_82470_);
            this.tail2Point = MathHelpers.rotateAroundCenter3dDeg(this.tail1Point, this.tail1Point.m_82546_(this.tail2Offset), -MathHelpers.angleTo((Vec3)this.tail1Point, (Vec3)this.tail2Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail1Point, (Vec3)this.tail2Point).f_82470_);
            this.tail3Point = MathHelpers.rotateAroundCenter3dDeg(this.tail2Point, this.tail2Point.m_82546_(this.tail3Offset), -MathHelpers.angleTo((Vec3)this.tail2Point, (Vec3)this.tail3Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail2Point, (Vec3)this.tail3Point).f_82470_);
            this.tail4Point = MathHelpers.rotateAroundCenter3dDeg(this.tail3Point, this.tail3Point.m_82546_(this.tail4Offset), -MathHelpers.angleTo((Vec3)this.tail3Point, (Vec3)this.tail4Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail3Point, (Vec3)this.tail4Point).f_82470_);
            this.tail5Point = MathHelpers.rotateAroundCenter3dDeg(this.tail4Point, this.tail4Point.m_82546_(this.tail5Offset), -MathHelpers.angleTo((Vec3)this.tail4Point, (Vec3)this.tail5Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail4Point, (Vec3)this.tail5Point).f_82470_);
            this.tail6Point = MathHelpers.rotateAroundCenter3dDeg(this.tail5Point, this.tail5Point.m_82546_(this.tail6Offset), -MathHelpers.angleTo((Vec3)this.tail5Point, (Vec3)this.tail6Point).f_82471_, -MathHelpers.angleTo((Vec3)this.tail5Point, (Vec3)this.tail6Point).f_82470_);
            this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-this.m_146908_()));
            this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-this.m_146908_()));
            this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-this.m_146908_()));
            this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(this.m_20182_(), this.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-this.m_146908_()));
            if (this.m_9236_().m_5776_()) {
                if (this.animTime == (int)(160.0 / this.animSpeed)) {
                    this.animTime = 0;
                    this.animSpeed = 0.5 + 1.0 * Math.random();
                } else {
                    ++this.animTime;
                }
            }
        }
        super.m_8119_();
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 2.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new CustomizableRandomSwimGoal((PathfinderMob)this, 0.8, 1, 20, 20, 2));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.m_5842_()) {
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("swimming", Animation.LoopType.LOOP));
        } else {
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("stranded", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public static <T extends Mob> boolean canSpawn(EntityType<RayEntity> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return WaterAnimal.m_218282_(p_223364_0_, (LevelAccessor)p_223364_1_, (MobSpawnType)reason, (BlockPos)p_223364_3_, (RandomSource)p_223364_4_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

