/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.goalz;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RandomSleepyWanderGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final PathfinderMob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;

    public RandomSleepyWanderGoal(PathfinderMob pMob, double pSpeedModifier) {
        this(pMob, pSpeedModifier, 120);
    }

    public RandomSleepyWanderGoal(PathfinderMob pMob, double pSpeedModifier, int pInterval) {
        this(pMob, pSpeedModifier, pInterval, true);
    }

    public RandomSleepyWanderGoal(PathfinderMob pMob, double pSpeedModifier, int pInterval, boolean pCheckNoActionTime) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.interval = pInterval;
        this.checkNoActionTime = pCheckNoActionTime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 vec3;
        if (this.mob.m_20160_()) {
            return false;
        }
        Level level = this.mob.m_9236_();
        long gameTime = level.m_46468_() % 24000L;
        if (gameTime >= 13000L && gameTime <= 22000L) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.m_21216_() >= 100) {
                return false;
            }
            if (this.mob.m_217043_().m_188503_(RandomSleepyWanderGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = vec3.f_82479_;
        this.wantedY = vec3.f_82480_;
        this.wantedZ = vec3.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
    }

    public boolean m_8045_() {
        Level level = this.mob.m_9236_();
        long gameTime = level.m_46468_() % 24000L;
        if (gameTime >= 13000L && gameTime <= 22000L) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int pNewchance) {
        this.interval = pNewchance;
    }
}

