/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MathHelpers {
    public static Vec2 angleTo(Vec3 target, Vec3 mePos) {
        double d0 = target.f_82479_ - mePos.f_82479_;
        double d1 = target.f_82480_ - mePos.f_82480_;
        double d2 = target.f_82481_ - mePos.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double XAngle = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        double YAngle = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return new Vec2((float)XAngle, (float)YAngle);
    }

    public static Vec3 rotateAroundCenterFlatDeg(Vec3 center, Vec3 me, Double angleInDeg) {
        angleInDeg = -(0.01745329238474369 * angleInDeg);
        double x1 = me.f_82479_ - center.f_82479_;
        double z1 = me.f_82481_ - center.f_82481_;
        double x2 = x1 * Math.cos(angleInDeg) - z1 * Math.sin(angleInDeg);
        double z2 = x1 * Math.sin(angleInDeg) + z1 * Math.cos(angleInDeg);
        double newMeX = x2 + center.f_82479_;
        double newMeZ = z2 + center.f_82481_;
        return new Vec3(newMeX, me.f_82480_, newMeZ);
    }

    public static Vec3 rotateAroundCenter3dDeg(Vec3 center, Vec3 me, float yRot, float xRot) {
        yRot = -((float)Math.PI / 180 * yRot);
        xRot = -((float)Math.PI / 180 * xRot);
        double x1 = me.f_82479_ - center.f_82479_;
        double z1 = me.f_82481_ - center.f_82481_;
        double y1 = me.f_82480_ - center.f_82480_;
        double x2 = x1 * Math.cos(yRot) - z1 * Math.sin(yRot);
        double z2 = x1 * Math.sin(yRot) + z1 * Math.cos(yRot);
        double y2 = -(z1 * Math.sin(xRot) + y1 * Math.cos(xRot));
        double newMeX = x2 + center.f_82479_;
        double newMeZ = z2 + center.f_82481_;
        double newMeY = y2 + center.f_82480_;
        return new Vec3(newMeX, newMeY, newMeZ);
    }

    public static double angleFromYdiff(Vec3 lead, Vec3 point, Vec3 trail) {
        double NextHeight = trail.f_82480_ - point.f_82480_;
        double PrevHeight = lead.f_82480_ - point.f_82480_;
        double distToNextFlat = MathHelpers.flatDist(point, trail);
        double distToPrevFlat = MathHelpers.flatDist(lead, point);
        double ThetaPrevious = Math.asin(PrevHeight / distToPrevFlat);
        double ThetaNext = Math.asin(NextHeight / distToNextFlat);
        if (PrevHeight / distToPrevFlat > 1.0) {
            ThetaPrevious = Math.asin(1.0);
        } else if (PrevHeight / distToPrevFlat < -1.0) {
            ThetaPrevious = Math.asin(-1.0);
        }
        if (NextHeight / distToNextFlat > 1.0) {
            ThetaNext = Math.asin(1.0);
        } else if (NextHeight / distToNextFlat < -1.0) {
            ThetaNext = Math.asin(-1.0);
        }
        return ThetaPrevious + ThetaNext;
    }

    public static double getAngleForLinkTopDownFlat(Vec3 point, Vec3 parent, Vec3 child, Vec3 leftRef, Vec3 rightRef) {
        double C = Math.hypot(Math.abs(parent.f_82479_ - child.f_82479_), Math.abs(parent.f_82481_ - child.f_82481_));
        double A = Math.hypot(Math.abs(parent.f_82479_ - point.f_82479_), Math.abs(parent.f_82481_ - point.f_82481_));
        double B = Math.hypot(Math.abs(point.f_82479_ - child.f_82479_), Math.abs(point.f_82481_ - child.f_82481_));
        double distToLeft = Math.abs(Math.hypot(child.f_82479_ - leftRef.f_82479_, child.f_82481_ - leftRef.f_82481_));
        double distToRight = Math.abs(Math.hypot(child.f_82479_ - rightRef.f_82479_, child.f_82481_ - rightRef.f_82481_));
        double c = Math.acos((A * A + B * B - C * C) / (2.0 * A * B));
        if (distToLeft >= distToRight) {
            return c;
        }
        return -c;
    }

    public static double angleClamp(double angle, double poslim) {
        if (angle > 0.0) {
            return Mth.m_14008_((double)angle, (double)poslim, (double)(6.2831854820251465 - poslim));
        }
        return Mth.m_14008_((double)angle, (double)(-(6.2831854820251465 - poslim)), (double)(-poslim));
    }

    public static double LerpDegrees(double start, double end, double amount) {
        double difference = Math.abs(end - start);
        if (difference > 3.1415927410125732) {
            if (end > start) {
                start += 6.2831854820251465;
            } else {
                end += 6.2831854820251465;
            }
        }
        double value = start + (end - start) * amount;
        float rangeZero = (float)Math.PI * 2;
        if (Double.isNaN(value)) {
            return 0.0;
        }
        if (value >= 0.0 && value <= 6.2831854820251465) {
            return value;
        }
        return value % (double)rangeZero;
    }

    public static double flatDist(Vec3 a, Vec3 b) {
        return Math.abs(Math.hypot(a.f_82479_ - b.f_82479_, a.f_82481_ - b.f_82481_));
    }
}

