/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.petemc.undeadnights.client.render.DemolitionZombieRenderer;
import net.petemc.undeadnights.client.render.EliteZombieRenderer;
import net.petemc.undeadnights.client.render.HordeZombieRenderer;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import org.slf4j.Logger;

@Mod(value="undeadnights")
public class UndeadNights {
    public static final String MOD_ID = "undeadnights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static StateSaverAndLoader serverState = null;
    public static int globalSpawnCounter = 0;

    public UndeadNights(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        UndeadNightsSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MainConfig.SPEC_SERVER);
        HordeConfig.loadConfig();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Initializing UndeadNights Mod");
        if (serverState == null) {
            serverState = StateSaverAndLoader.getServerState(event.getServer());
            if (serverState.getLastMaxDaysCounter() != MainConfig.getDaysBetweenHordeNights()) {
                serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                serverState.setLastMaxDaysCounter(MainConfig.getDaysBetweenHordeNights());
            }
            if (MainConfig.getPrintDebugMessages()) {
                LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)serverState.getDaysCounter(), (Object)serverState.getLastMaxDaysCounter());
                LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{serverState.getHordeNight(), serverState.getSpawnZombies(), serverState.getRespawnZombies()});
            }
        }
    }

    @Mod.EventBusSubscriber(modid="undeadnights", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.HORDE_ZOMBIE.get(), HordeZombieRenderer::new);
            EntityRenderers.register(ModEntities.DEMOLITION_ZOMBIE.get(), DemolitionZombieRenderer::new);
            EntityRenderers.register(ModEntities.ELITE_ZOMBIE.get(), EliteZombieRenderer::new);
        }
    }
}

