/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.petemc.undeadnights.config.MainConfig;
import org.jetbrains.annotations.NotNull;

public class StateSaverAndLoader
extends SavedData {
    private int daysCounter = MainConfig.getDaysBetweenHordeNights();
    private int lastMaxDaysCounter = MainConfig.getDaysBetweenHordeNights();
    private int tickCounter = 60;
    private boolean hordeNight = false;
    private boolean spawnZombies = true;
    private boolean respawnZombies = false;
    public HashSet<UUID> spawnedHordeMobs = new HashSet();

    public int getDaysCounter() {
        return this.daysCounter;
    }

    public void setDaysCounter(int val) {
        this.daysCounter = val;
        this.setDirty();
    }

    public int getLastMaxDaysCounter() {
        return this.lastMaxDaysCounter;
    }

    public void setLastMaxDaysCounter(int val) {
        this.lastMaxDaysCounter = val;
        this.setDirty();
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int val) {
        this.tickCounter = val;
        this.setDirty();
    }

    public boolean getHordeNight() {
        return this.hordeNight;
    }

    public void setHordeNight(boolean val) {
        this.hordeNight = val;
        this.setDirty();
    }

    public boolean getSpawnZombies() {
        return this.spawnZombies;
    }

    public void setSpawnZombies(boolean val) {
        this.spawnZombies = val;
        this.setDirty();
    }

    public boolean getRespawnZombies() {
        return this.respawnZombies;
    }

    public void setRespawnZombies(boolean val) {
        this.respawnZombies = val;
        this.setDirty();
    }

    public static StateSaverAndLoader load(CompoundTag tag, HolderLookup.Provider registries) {
        StateSaverAndLoader state = new StateSaverAndLoader();
        state.daysCounter = tag.getInt("daysCounter");
        state.lastMaxDaysCounter = tag.getInt("lastMaxDaysCounter");
        state.tickCounter = tag.getInt("tickCounter");
        state.hordeNight = tag.getBoolean("hordeNight");
        state.spawnZombies = tag.getBoolean("spawnZombies");
        state.respawnZombies = tag.getBoolean("respawnZombies");
        CompoundTag mobUUIDs = tag.getCompound("spawnedHordeMobs");
        mobUUIDs.getAllKeys().forEach(key -> {
            UUID hordeMobUUID = mobUUIDs.getUUID(key);
            state.spawnedHordeMobs.add(hordeMobUUID);
        });
        state.setDirty();
        return state;
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        tag.putInt("daysCounter", this.daysCounter);
        tag.putInt("lastMaxDaysCounter", this.lastMaxDaysCounter);
        tag.putInt("tickCounter", this.tickCounter);
        tag.putBoolean("hordeNight", this.hordeNight);
        tag.putBoolean("spawnZombies", this.spawnZombies);
        tag.putBoolean("respawnZombies", this.respawnZombies);
        CompoundTag mobUUIDs = new CompoundTag();
        this.spawnedHordeMobs.forEach(uuid -> mobUUIDs.putUUID(uuid.toString(), uuid));
        tag.put("spawnedHordeMobs", (Tag)mobUUIDs);
        return tag;
    }

    public static SavedData.Factory<StateSaverAndLoader> factory() {
        return new SavedData.Factory(StateSaverAndLoader::new, StateSaverAndLoader::load, null);
    }

    public static StateSaverAndLoader getServerState(MinecraftServer server) {
        return (StateSaverAndLoader)server.overworld().getDataStorage().computeIfAbsent(StateSaverAndLoader.factory(), "undeadnights");
    }
}

