/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.config.IFBPConfig;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import org.apache.commons.compress.utils.Lists;

public final class FBPConfig
implements IFBPConfig<FBPConfig> {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final FBPConfig DEFAULT_CONFIG = new FBPConfig(Global.DEFAULT_CONFIG, Terrain.DEFAULT_CONFIG, Flame.DEFAULT_CONFIG, Smoke.DEFAULT_CONFIG, CampfireSmoke.DEFAULT_CONFIG, Rain.DEFAULT_CONFIG, Snow.DEFAULT_CONFIG, Drip.DEFAULT_CONFIG, Misc.DEFAULT_CONFIG, Animations.DEFAULT_CONFIG, Overlay.DEFAULT_CONFIG);
    public final Global global;
    public final Terrain terrain;
    public final Flame flame;
    public final Smoke smoke;
    public final CampfireSmoke campfireSmoke;
    public final Rain rain;
    public final Snow snow;
    public final Drip drip;
    public final Misc misc;
    public final Animations animations;
    public final Overlay overlay;

    public void toggleParticles(Block block) {
        if (this.isBlockParticlesEnabled(block)) {
            this.global.disabledParticles.add(block);
        } else {
            this.global.disabledParticles.remove(block);
        }
    }

    public void toggleAnimations(Block block) {
        if (this.isBlockAnimationsEnabled(block)) {
            this.global.disabledAnimations.add(block);
        } else {
            this.global.disabledAnimations.remove(block);
        }
    }

    public boolean isBlockParticlesEnabled(Block block) {
        return !this.global.disabledParticles.contains(block);
    }

    public boolean isBlockAnimationsEnabled(Block block) {
        return !this.global.disabledAnimations.contains(block);
    }

    public static FBPConfig create() {
        return DEFAULT_CONFIG.copy();
    }

    @Override
    public void setConfig(FBPConfig config) {
        this.global.setConfig(config.global);
        this.terrain.setConfig(config.terrain);
        this.flame.setConfig(config.flame);
        this.smoke.setConfig(config.smoke);
        this.campfireSmoke.setConfig(config.campfireSmoke);
        this.rain.setConfig(config.rain);
        this.snow.setConfig(config.snow);
        this.drip.setConfig(config.drip);
        this.misc.setConfig(config.misc);
        this.animations.setConfig(config.animations);
        this.overlay.setConfig(config.overlay);
    }

    @Override
    public void applyConfig(FBPConfig config) {
        this.global.applyConfig(config.global);
        this.terrain.applyConfig(config.terrain);
        this.flame.applyConfig(config.flame);
        this.smoke.applyConfig(config.smoke);
        this.campfireSmoke.applyConfig(config.campfireSmoke);
        this.rain.applyConfig(config.rain);
        this.snow.applyConfig(config.snow);
        this.drip.applyConfig(config.drip);
        this.misc.applyConfig(config.misc);
        this.animations.applyConfig(config.animations);
        this.overlay.applyConfig(config.overlay);
    }

    @Override
    public void load() {
        try {
            Files.createDirectory(FBPConstants.CONFIG_PATH, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            FancyBlockParticles.LOGGER.debug("{} config directory already exists.", (Object)"FancyBlockParticles");
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Failed to create {} config directory.", (Object)"FancyBlockParticles");
        }
        File file = new File(FBPConstants.CONFIG_PATH.toString(), "config.json");
        try {
            if (!file.exists()) {
                file.createNewFile();
                this.save();
            }
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(new FileInputStream(file))).getAsJsonObject();
            this.global.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"global", (JsonObject)new JsonObject()));
            this.terrain.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"terrain", (JsonObject)new JsonObject()));
            this.flame.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"flame", (JsonObject)new JsonObject()));
            this.smoke.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"smoke", (JsonObject)new JsonObject()));
            this.campfireSmoke.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"campfireSmoke", (JsonObject)new JsonObject()));
            this.rain.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"rain", (JsonObject)new JsonObject()));
            this.snow.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"snow", (JsonObject)new JsonObject()));
            this.drip.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"drip", (JsonObject)new JsonObject()));
            this.misc.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"misc", (JsonObject)new JsonObject()));
            this.animations.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"animations", (JsonObject)new JsonObject()));
            this.overlay.load(GsonHelper.getAsJsonObject((JsonObject)json, (String)"overlay", (JsonObject)new JsonObject()));
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Could no load FBP config.", (Throwable)e);
        }
        catch (JsonParseException | IllegalStateException e) {
            FancyBlockParticles.LOGGER.warn("FBP config file is corrupt! Generating a new one.");
            this.save();
        }
    }

    @Override
    public JsonObject save() {
        JsonObject json = new JsonObject();
        try (FileWriter writer = new FileWriter(new File(FBPConstants.CONFIG_PATH.toString(), "config.json"));){
            json.add("global", (JsonElement)this.global.save());
            json.add("terrain", (JsonElement)this.terrain.save());
            json.add("flame", (JsonElement)this.flame.save());
            json.add("smoke", (JsonElement)this.smoke.save());
            json.add("campfireSmoke", (JsonElement)this.campfireSmoke.save());
            json.add("rain", (JsonElement)this.rain.save());
            json.add("snow", (JsonElement)this.snow.save());
            json.add("drip", (JsonElement)this.drip.save());
            json.add("misc", (JsonElement)this.misc.save());
            json.add("animations", (JsonElement)this.animations.save());
            json.add("overlay", (JsonElement)this.overlay.save());
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Could no save FBP config.", (Throwable)e);
        }
        return json;
    }

    @Override
    public void reset() {
        this.setConfig(DEFAULT_CONFIG.copy());
    }

    @Override
    public FBPConfig copy() {
        return new FBPConfig(this.global.copy(), this.terrain.copy(), this.flame.copy(), this.smoke.copy(), this.campfireSmoke.copy(), this.rain.copy(), this.snow.copy(), this.drip.copy(), this.misc.copy(), this.animations.copy(), this.overlay.copy());
    }

    @Generated
    public Global getGlobal() {
        return this.global;
    }

    @Generated
    public Terrain getTerrain() {
        return this.terrain;
    }

    @Generated
    public Flame getFlame() {
        return this.flame;
    }

    @Generated
    public Smoke getSmoke() {
        return this.smoke;
    }

    @Generated
    public CampfireSmoke getCampfireSmoke() {
        return this.campfireSmoke;
    }

    @Generated
    public Rain getRain() {
        return this.rain;
    }

    @Generated
    public Snow getSnow() {
        return this.snow;
    }

    @Generated
    public Drip getDrip() {
        return this.drip;
    }

    @Generated
    public Misc getMisc() {
        return this.misc;
    }

    @Generated
    public Animations getAnimations() {
        return this.animations;
    }

    @Generated
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Generated
    private FBPConfig(Global global, Terrain terrain, Flame flame, Smoke smoke, CampfireSmoke campfireSmoke, Rain rain, Snow snow, Drip drip, Misc misc, Animations animations, Overlay overlay) {
        this.global = global;
        this.terrain = terrain;
        this.flame = flame;
        this.smoke = smoke;
        this.campfireSmoke = campfireSmoke;
        this.rain = rain;
        this.snow = snow;
        this.drip = drip;
        this.misc = misc;
        this.animations = animations;
        this.overlay = overlay;
    }

    public static class Global
    implements IFBPConfig<Global> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_LOCKED = false;
        private static final boolean DEFAULT_DISABLE_OCULUS_WARNING = false;
        private static final boolean DEFAULT_FREEZE_EFFECT = false;
        private static final boolean DEFAULT_CARTOON_MODE = false;
        private static final boolean DEFAULT_CULL_PARTICLES = true;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final List<Block> DEFAULT_DISABLED_PARTICLES = Lists.newArrayList();
        private static final List<Block> DEFAULT_DISABLED_ANIMATIONS = Lists.newArrayList();
        public static final Global DEFAULT_CONFIG = new Global(true, false, false, false, false, true, false, DEFAULT_DISABLED_PARTICLES, DEFAULT_DISABLED_ANIMATIONS);
        private boolean enabled;
        private boolean locked;
        private boolean disableOculusWarning;
        private boolean freezeEffect;
        private boolean cartoonMode;
        private boolean cullParticles;
        private boolean infiniteDuration;
        private List<Block> disabledParticles;
        private List<Block> disabledAnimations;

        @Override
        public void setConfig(Global config) {
            this.enabled = config.enabled;
            this.locked = config.locked;
            this.freezeEffect = config.freezeEffect;
            this.cartoonMode = config.cartoonMode;
            this.cullParticles = config.cullParticles;
            this.infiniteDuration = config.infiniteDuration;
            this.disabledParticles = new ArrayList<Block>(config.disabledParticles);
            this.disabledAnimations = new ArrayList<Block>(config.disabledAnimations);
        }

        @Override
        public void applyConfig(Global config) {
            this.enabled = config.enabled;
            this.locked = config.locked;
            this.freezeEffect = config.freezeEffect;
            this.cartoonMode = config.cartoonMode;
            this.cullParticles = config.cullParticles;
            this.infiniteDuration = config.infiniteDuration;
            this.disabledParticles.addAll(config.disabledParticles);
            this.disabledAnimations.addAll(config.disabledAnimations);
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.locked = GsonHelper.getAsBoolean((JsonObject)json, (String)"locked", (boolean)false);
            this.disableOculusWarning = GsonHelper.getAsBoolean((JsonObject)json, (String)"disableOculusWarning", (boolean)false);
            this.freezeEffect = GsonHelper.getAsBoolean((JsonObject)json, (String)"freezeEffect", (boolean)false);
            this.cartoonMode = GsonHelper.getAsBoolean((JsonObject)json, (String)"cartoonMode", (boolean)false);
            this.cullParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"cullParticles", (boolean)true);
            this.infiniteDuration = GsonHelper.getAsBoolean((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.disabledParticles = (List)Util.make((Object)Lists.newArrayList(), disabled -> {
                if (json.has("disabledParticles")) {
                    for (JsonElement entry : GsonHelper.getAsJsonArray((JsonObject)json, (String)"disabledParticles")) {
                        disabled.add(Services.REGISTRY.getBlock(new ResourceLocation(entry.getAsString())));
                    }
                } else {
                    disabled.addAll(DEFAULT_DISABLED_PARTICLES);
                }
            });
            this.disabledAnimations = (List)Util.make((Object)Lists.newArrayList(), disabled -> {
                if (json.has("disabledAnimations")) {
                    for (JsonElement entry : GsonHelper.getAsJsonArray((JsonObject)json, (String)"disabledAnimations")) {
                        disabled.add(Services.REGISTRY.getBlock(new ResourceLocation(entry.getAsString())));
                    }
                } else {
                    disabled.addAll(DEFAULT_DISABLED_ANIMATIONS);
                }
            });
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("locked", Boolean.valueOf(this.locked));
            json.addProperty("disableOculusWarning", Boolean.valueOf(this.disableOculusWarning));
            json.addProperty("freezeEffect", Boolean.valueOf(this.freezeEffect));
            json.addProperty("cartoonMode", Boolean.valueOf(this.cartoonMode));
            json.addProperty("cullParticles", Boolean.valueOf(this.cullParticles));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.add("disabledParticles", (JsonElement)Util.make((Object)new JsonArray(), disabled -> {
                for (Block entry : this.disabledParticles) {
                    disabled.add(Services.REGISTRY.getBlockKey(entry).toString());
                }
            }));
            json.add("disabledAnimations", (JsonElement)Util.make((Object)new JsonArray(), disabled -> {
                for (Block entry : this.disabledAnimations) {
                    disabled.add(Services.REGISTRY.getBlockKey(entry).toString());
                }
            }));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Global copy() {
            return new Global(this.enabled, this.locked, this.disableOculusWarning, this.freezeEffect, this.cartoonMode, this.cullParticles, this.infiniteDuration, new ArrayList<Block>(this.disabledParticles), new ArrayList<Block>(this.disabledAnimations));
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isLocked() {
            return this.locked;
        }

        @Generated
        public boolean isDisableOculusWarning() {
            return this.disableOculusWarning;
        }

        @Generated
        public boolean isFreezeEffect() {
            return this.freezeEffect;
        }

        @Generated
        public boolean isCartoonMode() {
            return this.cartoonMode;
        }

        @Generated
        public boolean isCullParticles() {
            return this.cullParticles;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public List<Block> getDisabledParticles() {
            return this.disabledParticles;
        }

        @Generated
        public List<Block> getDisabledAnimations() {
            return this.disabledAnimations;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        @Generated
        public void setDisableOculusWarning(boolean disableOculusWarning) {
            this.disableOculusWarning = disableOculusWarning;
        }

        @Generated
        public void setFreezeEffect(boolean freezeEffect) {
            this.freezeEffect = freezeEffect;
        }

        @Generated
        public void setCartoonMode(boolean cartoonMode) {
            this.cartoonMode = cartoonMode;
        }

        @Generated
        public void setCullParticles(boolean cullParticles) {
            this.cullParticles = cullParticles;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        private Global(boolean enabled, boolean locked, boolean disableOculusWarning, boolean freezeEffect, boolean cartoonMode, boolean cullParticles, boolean infiniteDuration, List<Block> disabledParticles, List<Block> disabledAnimations) {
            this.enabled = enabled;
            this.locked = locked;
            this.disableOculusWarning = disableOculusWarning;
            this.freezeEffect = freezeEffect;
            this.cartoonMode = cartoonMode;
            this.cullParticles = cullParticles;
            this.infiniteDuration = infiniteDuration;
            this.disabledParticles = disabledParticles;
            this.disabledAnimations = disabledAnimations;
        }

        @Generated
        private void setDisabledParticles(List<Block> disabledParticles) {
            this.disabledParticles = disabledParticles;
        }

        @Generated
        private void setDisabledAnimations(List<Block> disabledAnimations) {
            this.disabledAnimations = disabledAnimations;
        }
    }

    public static class Terrain
    implements IFBPConfig<Terrain> {
        private static final boolean DEFAULT_FANCY_BREAKING_PARTICLES = true;
        private static final boolean DEFAULT_FANCY_CRACKING_PARTICLES = true;
        private static final boolean DEFAULT_FANCY_FALLING_DUST_PARTICLES = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = true;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_SMART_BREAKING = true;
        private static final boolean DEFAULT_LOW_TRACTION = false;
        private static final boolean DEFAULT_REST_ON_FLOOR = true;
        private static final boolean DEFAULT_BOUNCE_OFF_WALLS = true;
        private static final boolean DEFAULT_ENTITY_COLLISION = false;
        private static final boolean DEFAULT_WATER_PHYSICS = true;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_ROTATION = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_PARTICLES_PER_AXIS = 4;
        private static final int DEFAULT_MIN_LIFETIME = 10;
        private static final int DEFAULT_MAX_LIFETIME = 55;
        private static final float DEFAULT_SIZE_MULTIPLIER = 0.75f;
        private static final float DEFAULT_ROTATION_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Terrain DEFAULT_CONFIG = new Terrain(true, true, true, true, false, true, false, true, true, false, true, true, true, true, 4, 10, 55, 0.75f, 1.0f, 1.0f);
        private boolean fancyBreakingParticles;
        private boolean fancyCrackingParticles;
        private boolean fancyFallingDustParticles;
        private boolean spawnWhileFrozen;
        private boolean infiniteDuration;
        private boolean smartBreaking;
        private boolean lowTraction;
        private boolean restOnFloor;
        private boolean bounceOffWalls;
        private boolean entityCollision;
        private boolean waterPhysics;
        private boolean randomSize;
        private boolean randomRotation;
        private boolean randomFadingSpeed;
        private int particlesPerAxis;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;
        private float rotationMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Terrain config) {
            this.fancyBreakingParticles = config.fancyBreakingParticles;
            this.fancyCrackingParticles = config.fancyCrackingParticles;
            this.fancyFallingDustParticles = config.fancyFallingDustParticles;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.infiniteDuration = config.infiniteDuration;
            this.smartBreaking = config.smartBreaking;
            this.lowTraction = config.lowTraction;
            this.restOnFloor = config.restOnFloor;
            this.bounceOffWalls = config.bounceOffWalls;
            this.entityCollision = config.entityCollision;
            this.waterPhysics = config.waterPhysics;
            this.randomSize = config.randomSize;
            this.randomRotation = config.randomRotation;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.particlesPerAxis = config.particlesPerAxis;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
            this.rotationMultiplier = config.rotationMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.fancyBreakingParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancyBreakingParticles", (boolean)true);
            this.fancyCrackingParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancyCrackingParticles", (boolean)true);
            this.fancyFallingDustParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancyFallingDustParticles", (boolean)true);
            this.spawnWhileFrozen = GsonHelper.getAsBoolean((JsonObject)json, (String)"spawnWhileFrozen", (boolean)true);
            this.infiniteDuration = GsonHelper.getAsBoolean((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.smartBreaking = GsonHelper.getAsBoolean((JsonObject)json, (String)"smartBreaking", (boolean)true);
            this.lowTraction = GsonHelper.getAsBoolean((JsonObject)json, (String)"lowTraction", (boolean)false);
            this.restOnFloor = GsonHelper.getAsBoolean((JsonObject)json, (String)"restOnFloor", (boolean)true);
            this.bounceOffWalls = GsonHelper.getAsBoolean((JsonObject)json, (String)"bounceOffWalls", (boolean)true);
            this.entityCollision = GsonHelper.getAsBoolean((JsonObject)json, (String)"entityCollision", (boolean)false);
            this.waterPhysics = GsonHelper.getAsBoolean((JsonObject)json, (String)"waterPhysics", (boolean)true);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomRotation = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomRotation", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.particlesPerAxis = GsonHelper.getAsInt((JsonObject)json, (String)"particlesPerAxis", (int)4);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)10);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)55);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)0.75f);
            this.rotationMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"rotationMultiplier", (float)1.0f);
            this.gravityMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("fancyBreakingParticles", Boolean.valueOf(this.fancyBreakingParticles));
            json.addProperty("fancyCrackingParticles", Boolean.valueOf(this.fancyCrackingParticles));
            json.addProperty("fancyFallingDustParticles", Boolean.valueOf(this.fancyFallingDustParticles));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("smartBreaking", Boolean.valueOf(this.smartBreaking));
            json.addProperty("lowTraction", Boolean.valueOf(this.lowTraction));
            json.addProperty("restOnFloor", Boolean.valueOf(this.restOnFloor));
            json.addProperty("bounceOffWalls", Boolean.valueOf(this.bounceOffWalls));
            json.addProperty("entityCollision", Boolean.valueOf(this.entityCollision));
            json.addProperty("waterPhysics", Boolean.valueOf(this.waterPhysics));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomRotation", Boolean.valueOf(this.randomRotation));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("particlesPerAxis", (Number)this.particlesPerAxis);
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("rotationMultiplier", (Number)Float.valueOf(this.rotationMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Terrain copy() {
            return new Terrain(this.fancyBreakingParticles, this.fancyCrackingParticles, this.fancyFallingDustParticles, this.spawnWhileFrozen, this.infiniteDuration, this.smartBreaking, this.lowTraction, this.restOnFloor, this.bounceOffWalls, this.entityCollision, this.waterPhysics, this.randomSize, this.randomRotation, this.randomFadingSpeed, this.particlesPerAxis, this.minLifetime, this.maxLifetime, this.sizeMultiplier, this.rotationMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isFancyBreakingParticles() {
            return this.fancyBreakingParticles;
        }

        @Generated
        public boolean isFancyCrackingParticles() {
            return this.fancyCrackingParticles;
        }

        @Generated
        public boolean isFancyFallingDustParticles() {
            return this.fancyFallingDustParticles;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isSmartBreaking() {
            return this.smartBreaking;
        }

        @Generated
        public boolean isLowTraction() {
            return this.lowTraction;
        }

        @Generated
        public boolean isRestOnFloor() {
            return this.restOnFloor;
        }

        @Generated
        public boolean isBounceOffWalls() {
            return this.bounceOffWalls;
        }

        @Generated
        public boolean isEntityCollision() {
            return this.entityCollision;
        }

        @Generated
        public boolean isWaterPhysics() {
            return this.waterPhysics;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomRotation() {
            return this.randomRotation;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getParticlesPerAxis() {
            return this.particlesPerAxis;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getRotationMultiplier() {
            return this.rotationMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setFancyBreakingParticles(boolean fancyBreakingParticles) {
            this.fancyBreakingParticles = fancyBreakingParticles;
        }

        @Generated
        public void setFancyCrackingParticles(boolean fancyCrackingParticles) {
            this.fancyCrackingParticles = fancyCrackingParticles;
        }

        @Generated
        public void setFancyFallingDustParticles(boolean fancyFallingDustParticles) {
            this.fancyFallingDustParticles = fancyFallingDustParticles;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setSmartBreaking(boolean smartBreaking) {
            this.smartBreaking = smartBreaking;
        }

        @Generated
        public void setLowTraction(boolean lowTraction) {
            this.lowTraction = lowTraction;
        }

        @Generated
        public void setRestOnFloor(boolean restOnFloor) {
            this.restOnFloor = restOnFloor;
        }

        @Generated
        public void setBounceOffWalls(boolean bounceOffWalls) {
            this.bounceOffWalls = bounceOffWalls;
        }

        @Generated
        public void setEntityCollision(boolean entityCollision) {
            this.entityCollision = entityCollision;
        }

        @Generated
        public void setWaterPhysics(boolean waterPhysics) {
            this.waterPhysics = waterPhysics;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomRotation(boolean randomRotation) {
            this.randomRotation = randomRotation;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setParticlesPerAxis(int particlesPerAxis) {
            this.particlesPerAxis = particlesPerAxis;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setRotationMultiplier(float rotationMultiplier) {
            this.rotationMultiplier = rotationMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Terrain(boolean fancyBreakingParticles, boolean fancyCrackingParticles, boolean fancyFallingDustParticles, boolean spawnWhileFrozen, boolean infiniteDuration, boolean smartBreaking, boolean lowTraction, boolean restOnFloor, boolean bounceOffWalls, boolean entityCollision, boolean waterPhysics, boolean randomSize, boolean randomRotation, boolean randomFadingSpeed, int particlesPerAxis, int minLifetime, int maxLifetime, float sizeMultiplier, float rotationMultiplier, float gravityMultiplier) {
            this.fancyBreakingParticles = fancyBreakingParticles;
            this.fancyCrackingParticles = fancyCrackingParticles;
            this.fancyFallingDustParticles = fancyFallingDustParticles;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.infiniteDuration = infiniteDuration;
            this.smartBreaking = smartBreaking;
            this.lowTraction = lowTraction;
            this.restOnFloor = restOnFloor;
            this.bounceOffWalls = bounceOffWalls;
            this.entityCollision = entityCollision;
            this.waterPhysics = waterPhysics;
            this.randomSize = randomSize;
            this.randomRotation = randomRotation;
            this.randomFadingSpeed = randomFadingSpeed;
            this.particlesPerAxis = particlesPerAxis;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
            this.rotationMultiplier = rotationMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Flame
    implements IFBPConfig<Flame> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = false;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 10;
        private static final int DEFAULT_MAX_LIFETIME = 15;
        private static final float DEFAULT_SIZE_MULTIPLIER = 0.75f;
        public static final Flame DEFAULT_CONFIG = new Flame(true, false, false, true, true, 10, 15, 0.75f);
        private boolean enabled;
        private boolean spawnWhileFrozen;
        private boolean infiniteDuration;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;

        @Override
        public void setConfig(Flame config) {
            this.enabled = config.enabled;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.infiniteDuration = config.infiniteDuration;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.spawnWhileFrozen = GsonHelper.getAsBoolean((JsonObject)json, (String)"spawnWhileFrozen", (boolean)false);
            this.infiniteDuration = GsonHelper.getAsBoolean((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)10);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)15);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)0.75f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Flame copy() {
            return new Flame(this.enabled, this.spawnWhileFrozen, this.infiniteDuration, this.randomSize, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.sizeMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        private Flame(boolean enabled, boolean spawnWhileFrozen, boolean infiniteDuration, boolean randomSize, boolean randomFadingSpeed, int minLifetime, int maxLifetime, float sizeMultiplier) {
            this.enabled = enabled;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.infiniteDuration = infiniteDuration;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
        }
    }

    public static class Smoke
    implements IFBPConfig<Smoke> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = false;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 10;
        private static final int DEFAULT_MAX_LIFETIME = 15;
        private static final float DEFAULT_SIZE_MULTIPLIER = 0.75f;
        public static final Smoke DEFAULT_CONFIG = new Smoke(true, false, false, true, true, 10, 15, 0.75f);
        private boolean enabled;
        private boolean spawnWhileFrozen;
        private boolean infiniteDuration;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;

        @Override
        public void setConfig(Smoke config) {
            this.enabled = config.enabled;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.infiniteDuration = config.infiniteDuration;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.spawnWhileFrozen = GsonHelper.getAsBoolean((JsonObject)json, (String)"spawnWhileFrozen", (boolean)false);
            this.infiniteDuration = GsonHelper.getAsBoolean((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)10);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)15);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)0.75f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Smoke copy() {
            return new Smoke(this.enabled, this.spawnWhileFrozen, this.infiniteDuration, this.randomSize, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.sizeMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        private Smoke(boolean enabled, boolean spawnWhileFrozen, boolean infiniteDuration, boolean randomSize, boolean randomFadingSpeed, int minLifetime, int maxLifetime, float sizeMultiplier) {
            this.enabled = enabled;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.infiniteDuration = infiniteDuration;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
        }
    }

    public static class CampfireSmoke
    implements IFBPConfig<CampfireSmoke> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final float DEFAULT_TRANSPARENCY = 0.8f;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        public static final CampfireSmoke DEFAULT_CONFIG = new CampfireSmoke(true, false, true, true, 0.8f, 1.0f);
        private boolean enabled;
        private boolean spawnWhileFrozen;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private float transparency;
        private float sizeMultiplier;

        @Override
        public void setConfig(CampfireSmoke config) {
            this.enabled = config.enabled;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.transparency = config.transparency;
            this.sizeMultiplier = config.sizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.spawnWhileFrozen = GsonHelper.getAsBoolean((JsonObject)json, (String)"spawnWhileFrozen", (boolean)false);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.transparency = GsonHelper.getAsFloat((JsonObject)json, (String)"transparency", (float)0.8f);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("transparency", (Number)Float.valueOf(this.transparency));
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public CampfireSmoke copy() {
            return new CampfireSmoke(this.enabled, this.spawnWhileFrozen, this.randomSize, this.randomFadingSpeed, this.transparency, this.sizeMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public float getTransparency() {
            return this.transparency;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setTransparency(float transparency) {
            this.transparency = transparency;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        private CampfireSmoke(boolean enabled, boolean spawnWhileFrozen, boolean randomSize, boolean randomFadingSpeed, float transparency, float sizeMultiplier) {
            this.enabled = enabled;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.transparency = transparency;
            this.sizeMultiplier = sizeMultiplier;
        }
    }

    public static class Rain
    implements IFBPConfig<Rain> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_PUDDLE = true;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_RENDER_DISTANCE = 4;
        private static final int DEFAULT_SIMULATION_DISTANCE = 8;
        private static final float DEFAULT_TRANSPARENCY = 0.6f;
        private static final float DEFAULT_PARTICLE_DENSITY = 1.0f;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Rain DEFAULT_CONFIG = new Rain(true, true, true, true, 4, 8, 0.6f, 1.0f, 1.0f, 1.0f);
        private boolean enabled;
        private boolean puddle;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int renderDistance;
        private int simulationDistance;
        private float transparency;
        private float particleDensity;
        private float sizeMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Rain config) {
            this.enabled = config.enabled;
            this.puddle = config.puddle;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.renderDistance = config.renderDistance;
            this.simulationDistance = config.simulationDistance;
            this.transparency = config.transparency;
            this.particleDensity = config.particleDensity;
            this.sizeMultiplier = config.sizeMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.puddle = GsonHelper.getAsBoolean((JsonObject)json, (String)"puddle", (boolean)true);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.renderDistance = GsonHelper.getAsInt((JsonObject)json, (String)"renderDistance", (int)4);
            this.simulationDistance = GsonHelper.getAsInt((JsonObject)json, (String)"simulationDistance", (int)8);
            this.transparency = GsonHelper.getAsFloat((JsonObject)json, (String)"transparency", (float)0.6f);
            this.particleDensity = GsonHelper.getAsFloat((JsonObject)json, (String)"particleDensity", (float)1.0f);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
            this.gravityMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("puddle", Boolean.valueOf(this.puddle));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("renderDistance", (Number)this.renderDistance);
            json.addProperty("simulationDistance", (Number)this.simulationDistance);
            json.addProperty("transparency", (Number)Float.valueOf(this.transparency));
            json.addProperty("particleDensity", (Number)Float.valueOf(this.particleDensity));
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Rain copy() {
            return new Rain(this.enabled, this.puddle, this.randomSize, this.randomFadingSpeed, this.renderDistance, this.simulationDistance, this.transparency, this.particleDensity, this.sizeMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isPuddle() {
            return this.puddle;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getRenderDistance() {
            return this.renderDistance;
        }

        @Generated
        public int getSimulationDistance() {
            return this.simulationDistance;
        }

        @Generated
        public float getTransparency() {
            return this.transparency;
        }

        @Generated
        public float getParticleDensity() {
            return this.particleDensity;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setPuddle(boolean puddle) {
            this.puddle = puddle;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setRenderDistance(int renderDistance) {
            this.renderDistance = renderDistance;
        }

        @Generated
        public void setSimulationDistance(int simulationDistance) {
            this.simulationDistance = simulationDistance;
        }

        @Generated
        public void setTransparency(float transparency) {
            this.transparency = transparency;
        }

        @Generated
        public void setParticleDensity(float particleDensity) {
            this.particleDensity = particleDensity;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Rain(boolean enabled, boolean puddle, boolean randomSize, boolean randomFadingSpeed, int renderDistance, int simulationDistance, float transparency, float particleDensity, float sizeMultiplier, float gravityMultiplier) {
            this.enabled = enabled;
            this.puddle = puddle;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.renderDistance = renderDistance;
            this.simulationDistance = simulationDistance;
            this.transparency = transparency;
            this.particleDensity = particleDensity;
            this.sizeMultiplier = sizeMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Snow
    implements IFBPConfig<Snow> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_LOW_TRACTION = false;
        private static final boolean DEFAULT_REST_ON_FLOOR = true;
        private static final boolean DEFAULT_BOUNCE_OFF_WALLS = true;
        private static final boolean DEFAULT_WATER_PHYSICS = true;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_ROTATION = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 250;
        private static final int DEFAULT_MAX_LIFETIME = 300;
        private static final int DEFAULT_RENDER_DISTANCE = 4;
        private static final int DEFAULT_SIMULATION_DISTANCE = 8;
        private static final float DEFAULT_PARTICLE_DENSITY = 1.0f;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_ROTATION_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Snow DEFAULT_CONFIG = new Snow(true, false, true, true, true, false, true, true, true, 250, 300, 4, 8, 1.0f, 1.0f, 1.0f, 1.0f);
        private boolean enabled;
        private boolean lowTraction;
        private boolean restOnFloor;
        private boolean bounceOffWalls;
        private boolean waterPhysics;
        private boolean infiniteDuration;
        private boolean randomSize;
        private boolean randomRotation;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private int renderDistance;
        private int simulationDistance;
        private float particleDensity;
        private float sizeMultiplier;
        private float rotationMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Snow config) {
            this.enabled = config.enabled;
            this.lowTraction = config.lowTraction;
            this.restOnFloor = config.restOnFloor;
            this.bounceOffWalls = config.bounceOffWalls;
            this.waterPhysics = config.waterPhysics;
            this.infiniteDuration = config.infiniteDuration;
            this.randomSize = config.randomSize;
            this.randomRotation = config.randomRotation;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.renderDistance = config.renderDistance;
            this.simulationDistance = config.simulationDistance;
            this.particleDensity = config.particleDensity;
            this.sizeMultiplier = config.sizeMultiplier;
            this.rotationMultiplier = config.rotationMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.lowTraction = GsonHelper.getAsBoolean((JsonObject)json, (String)"lowTraction", (boolean)false);
            this.restOnFloor = GsonHelper.getAsBoolean((JsonObject)json, (String)"restOnFloor", (boolean)true);
            this.bounceOffWalls = GsonHelper.getAsBoolean((JsonObject)json, (String)"bounceOffWalls", (boolean)true);
            this.waterPhysics = GsonHelper.getAsBoolean((JsonObject)json, (String)"waterPhysics", (boolean)true);
            this.infiniteDuration = GsonHelper.getAsBoolean((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomRotation = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomRotation", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)250);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)300);
            this.renderDistance = GsonHelper.getAsInt((JsonObject)json, (String)"renderDistance", (int)4);
            this.simulationDistance = GsonHelper.getAsInt((JsonObject)json, (String)"simulationDistance", (int)8);
            this.particleDensity = GsonHelper.getAsFloat((JsonObject)json, (String)"particleDensity", (float)1.0f);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
            this.rotationMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"rotationMultiplier", (float)1.0f);
            this.gravityMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("lowTraction", Boolean.valueOf(this.lowTraction));
            json.addProperty("restOnFloor", Boolean.valueOf(this.restOnFloor));
            json.addProperty("bounceOffWalls", Boolean.valueOf(this.bounceOffWalls));
            json.addProperty("waterPhysics", Boolean.valueOf(this.waterPhysics));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomRotation", Boolean.valueOf(this.randomRotation));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("renderDistance", (Number)this.renderDistance);
            json.addProperty("simulationDistance", (Number)this.simulationDistance);
            json.addProperty("particleDensity", (Number)Float.valueOf(this.particleDensity));
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("rotationMultiplier", (Number)Float.valueOf(this.rotationMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Snow copy() {
            return new Snow(this.enabled, this.lowTraction, this.restOnFloor, this.bounceOffWalls, this.waterPhysics, this.infiniteDuration, this.randomSize, this.randomRotation, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.renderDistance, this.simulationDistance, this.particleDensity, this.sizeMultiplier, this.rotationMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isLowTraction() {
            return this.lowTraction;
        }

        @Generated
        public boolean isRestOnFloor() {
            return this.restOnFloor;
        }

        @Generated
        public boolean isBounceOffWalls() {
            return this.bounceOffWalls;
        }

        @Generated
        public boolean isWaterPhysics() {
            return this.waterPhysics;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomRotation() {
            return this.randomRotation;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public int getRenderDistance() {
            return this.renderDistance;
        }

        @Generated
        public int getSimulationDistance() {
            return this.simulationDistance;
        }

        @Generated
        public float getParticleDensity() {
            return this.particleDensity;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getRotationMultiplier() {
            return this.rotationMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setLowTraction(boolean lowTraction) {
            this.lowTraction = lowTraction;
        }

        @Generated
        public void setRestOnFloor(boolean restOnFloor) {
            this.restOnFloor = restOnFloor;
        }

        @Generated
        public void setBounceOffWalls(boolean bounceOffWalls) {
            this.bounceOffWalls = bounceOffWalls;
        }

        @Generated
        public void setWaterPhysics(boolean waterPhysics) {
            this.waterPhysics = waterPhysics;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomRotation(boolean randomRotation) {
            this.randomRotation = randomRotation;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setRenderDistance(int renderDistance) {
            this.renderDistance = renderDistance;
        }

        @Generated
        public void setSimulationDistance(int simulationDistance) {
            this.simulationDistance = simulationDistance;
        }

        @Generated
        public void setParticleDensity(float particleDensity) {
            this.particleDensity = particleDensity;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setRotationMultiplier(float rotationMultiplier) {
            this.rotationMultiplier = rotationMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Snow(boolean enabled, boolean lowTraction, boolean restOnFloor, boolean bounceOffWalls, boolean waterPhysics, boolean infiniteDuration, boolean randomSize, boolean randomRotation, boolean randomFadingSpeed, int minLifetime, int maxLifetime, int renderDistance, int simulationDistance, float particleDensity, float sizeMultiplier, float rotationMultiplier, float gravityMultiplier) {
            this.enabled = enabled;
            this.lowTraction = lowTraction;
            this.restOnFloor = restOnFloor;
            this.bounceOffWalls = bounceOffWalls;
            this.waterPhysics = waterPhysics;
            this.infiniteDuration = infiniteDuration;
            this.randomSize = randomSize;
            this.randomRotation = randomRotation;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.renderDistance = renderDistance;
            this.simulationDistance = simulationDistance;
            this.particleDensity = particleDensity;
            this.sizeMultiplier = sizeMultiplier;
            this.rotationMultiplier = rotationMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Drip
    implements IFBPConfig<Drip> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_PUDDLE = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = true;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 60;
        private static final int DEFAULT_MAX_LIFETIME = 100;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Drip DEFAULT_CONFIG = new Drip(true, true, true, true, true, 60, 100, 1.0f, 1.0f);
        private boolean enabled;
        private boolean puddle;
        private boolean spawnWhileFrozen;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Drip config) {
            this.enabled = config.enabled;
            this.puddle = config.puddle;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.puddle = GsonHelper.getAsBoolean((JsonObject)json, (String)"puddle", (boolean)true);
            this.spawnWhileFrozen = GsonHelper.getAsBoolean((JsonObject)json, (String)"spawnWhileFrozen", (boolean)true);
            this.randomSize = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = GsonHelper.getAsBoolean((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)60);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)100);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
            this.gravityMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("puddle", Boolean.valueOf(this.puddle));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Drip copy() {
            return new Drip(this.enabled, this.puddle, this.spawnWhileFrozen, this.randomSize, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.sizeMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isPuddle() {
            return this.puddle;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setPuddle(boolean puddle) {
            this.puddle = puddle;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Drip(boolean enabled, boolean puddle, boolean spawnWhileFrozen, boolean randomSize, boolean randomFadingSpeed, int minLifetime, int maxLifetime, float sizeMultiplier, float gravityMultiplier) {
            this.enabled = enabled;
            this.puddle = puddle;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Misc
    implements IFBPConfig<Misc> {
        private static final boolean DEFAULT_FANCY_SNOWBALL_PARTICLES = true;
        private static final boolean DEFAULT_FANCY_SLIME_PARTICLES = true;
        private static final boolean DEFAULT_FANCY_BREAKING_SPLASH_POTION_PARTICLES = true;
        private static final float DEFAULT_SNOWBALL_PARTICLE_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_SLIME_PARTICLE_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_BREAKING_SPLASH_POTION_PARTICLE_SIZE_MULTIPLIER = 1.0f;
        public static final Misc DEFAULT_CONFIG = new Misc(true, true, true, 1.0f, 1.0f, 1.0f);
        private boolean fancySnowballParticles;
        private boolean fancySlimeParticles;
        private boolean fancyBreakingSplashPotionParticles;
        private float snowballParticleSizeMultiplier;
        private float slimeParticleSizeMultiplier;
        private float breakingSplashPotionParticleSizeMultiplier;

        @Override
        public void setConfig(Misc config) {
            this.fancySnowballParticles = config.fancySnowballParticles;
            this.fancySlimeParticles = config.fancySlimeParticles;
            this.fancyBreakingSplashPotionParticles = config.fancyBreakingSplashPotionParticles;
            this.snowballParticleSizeMultiplier = config.snowballParticleSizeMultiplier;
            this.slimeParticleSizeMultiplier = config.slimeParticleSizeMultiplier;
            this.breakingSplashPotionParticleSizeMultiplier = config.breakingSplashPotionParticleSizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.fancySnowballParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancySnowballParticles", (boolean)true);
            this.fancySlimeParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancySlimeParticles", (boolean)true);
            this.fancyBreakingSplashPotionParticles = GsonHelper.getAsBoolean((JsonObject)json, (String)"fancyBreakingSplashPotionParticles", (boolean)true);
            this.snowballParticleSizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"snowballParticleSizeMultiplier", (float)1.0f);
            this.slimeParticleSizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"slimeParticleSizeMultiplier", (float)1.0f);
            this.breakingSplashPotionParticleSizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"breakingSplashPotionParticleSizeMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("fancySnowballParticles", Boolean.valueOf(this.fancySnowballParticles));
            json.addProperty("fancySlimeParticles", Boolean.valueOf(this.fancySlimeParticles));
            json.addProperty("fancyBreakingSplashPotionParticles", Boolean.valueOf(this.fancyBreakingSplashPotionParticles));
            json.addProperty("snowballParticleSizeMultiplier", (Number)Float.valueOf(this.snowballParticleSizeMultiplier));
            json.addProperty("slimeParticleSizeMultiplier", (Number)Float.valueOf(this.slimeParticleSizeMultiplier));
            json.addProperty("breakingSplashPotionParticleSizeMultiplier", (Number)Float.valueOf(this.breakingSplashPotionParticleSizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Misc copy() {
            return new Misc(this.fancySnowballParticles, this.fancySlimeParticles, this.fancyBreakingSplashPotionParticles, this.snowballParticleSizeMultiplier, this.slimeParticleSizeMultiplier, this.breakingSplashPotionParticleSizeMultiplier);
        }

        @Generated
        public boolean isFancySnowballParticles() {
            return this.fancySnowballParticles;
        }

        @Generated
        public boolean isFancySlimeParticles() {
            return this.fancySlimeParticles;
        }

        @Generated
        public boolean isFancyBreakingSplashPotionParticles() {
            return this.fancyBreakingSplashPotionParticles;
        }

        @Generated
        public float getSnowballParticleSizeMultiplier() {
            return this.snowballParticleSizeMultiplier;
        }

        @Generated
        public float getSlimeParticleSizeMultiplier() {
            return this.slimeParticleSizeMultiplier;
        }

        @Generated
        public float getBreakingSplashPotionParticleSizeMultiplier() {
            return this.breakingSplashPotionParticleSizeMultiplier;
        }

        @Generated
        public void setFancySnowballParticles(boolean fancySnowballParticles) {
            this.fancySnowballParticles = fancySnowballParticles;
        }

        @Generated
        public void setFancySlimeParticles(boolean fancySlimeParticles) {
            this.fancySlimeParticles = fancySlimeParticles;
        }

        @Generated
        public void setFancyBreakingSplashPotionParticles(boolean fancyBreakingSplashPotionParticles) {
            this.fancyBreakingSplashPotionParticles = fancyBreakingSplashPotionParticles;
        }

        @Generated
        public void setSnowballParticleSizeMultiplier(float snowballParticleSizeMultiplier) {
            this.snowballParticleSizeMultiplier = snowballParticleSizeMultiplier;
        }

        @Generated
        public void setSlimeParticleSizeMultiplier(float slimeParticleSizeMultiplier) {
            this.slimeParticleSizeMultiplier = slimeParticleSizeMultiplier;
        }

        @Generated
        public void setBreakingSplashPotionParticleSizeMultiplier(float breakingSplashPotionParticleSizeMultiplier) {
            this.breakingSplashPotionParticleSizeMultiplier = breakingSplashPotionParticleSizeMultiplier;
        }

        @Generated
        private Misc(boolean fancySnowballParticles, boolean fancySlimeParticles, boolean fancyBreakingSplashPotionParticles, float snowballParticleSizeMultiplier, float slimeParticleSizeMultiplier, float breakingSplashPotionParticleSizeMultiplier) {
            this.fancySnowballParticles = fancySnowballParticles;
            this.fancySlimeParticles = fancySlimeParticles;
            this.fancyBreakingSplashPotionParticles = fancyBreakingSplashPotionParticles;
            this.snowballParticleSizeMultiplier = snowballParticleSizeMultiplier;
            this.slimeParticleSizeMultiplier = slimeParticleSizeMultiplier;
            this.breakingSplashPotionParticleSizeMultiplier = breakingSplashPotionParticleSizeMultiplier;
        }
    }

    public static class Animations
    implements IFBPConfig<Animations> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_RENDER_OUTLINE = false;
        private static final int DEFAULT_MIN_LIFETIME = 3;
        private static final int DEFAULT_MAX_LIFETIME = 3;
        private static final float DEFAULT_SCALE = 1.0f;
        public static final Animations DEFAULT_CONFIG = new Animations(true, false, 3, 3, 1.0f);
        private boolean enabled;
        private boolean renderOutline;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;

        @Override
        public void setConfig(Animations config) {
            if (this.enabled != config.enabled) {
                FBPPlacingAnimationManager.clear();
            }
            this.enabled = config.enabled;
            this.renderOutline = config.renderOutline;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = !Services.PLATFORM.isModLoaded("optifine") && GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
            this.renderOutline = GsonHelper.getAsBoolean((JsonObject)json, (String)"renderOutline", (boolean)false);
            this.minLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"minLifetime", (int)3);
            this.maxLifetime = GsonHelper.getAsInt((JsonObject)json, (String)"maxLifetime", (int)3);
            this.sizeMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("renderOutline", Boolean.valueOf(this.renderOutline));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Animations copy() {
            return new Animations(this.enabled, this.renderOutline, this.minLifetime, this.maxLifetime, this.sizeMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isRenderOutline() {
            return this.renderOutline;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        private Animations(boolean enabled, boolean renderOutline, int minLifetime, int maxLifetime, float sizeMultiplier) {
            this.enabled = enabled;
            this.renderOutline = renderOutline;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
        }
    }

    public static class Overlay
    implements IFBPConfig<Overlay> {
        private static final boolean DEFAULT_FREEZE_EFFECT_OVERLAY = true;
        private static final int DEFAULT_FREEZE_EFFECT_COLOR = 33023;
        public static final Overlay DEFAULT_CONFIG = new Overlay(true, 33023);
        private boolean freezeEffectOverlay;
        private int freezeEffectColor;

        @Override
        public void setConfig(Overlay config) {
            this.freezeEffectOverlay = config.freezeEffectOverlay;
            this.freezeEffectColor = config.freezeEffectColor;
        }

        @Override
        public void load(JsonObject json) {
            this.freezeEffectOverlay = GsonHelper.getAsBoolean((JsonObject)json, (String)"freezeEffectOverlay", (boolean)true);
            this.freezeEffectColor = GsonHelper.getAsInt((JsonObject)json, (String)"freezeEffectColor", (int)33023);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("freezeEffectOverlay", Boolean.valueOf(this.freezeEffectOverlay));
            json.addProperty("freezeEffectColor", (Number)this.freezeEffectColor);
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Overlay copy() {
            return new Overlay(this.freezeEffectOverlay, this.freezeEffectColor);
        }

        @Generated
        public boolean isFreezeEffectOverlay() {
            return this.freezeEffectOverlay;
        }

        @Generated
        public int getFreezeEffectColor() {
            return this.freezeEffectColor;
        }

        @Generated
        public void setFreezeEffectOverlay(boolean freezeEffectOverlay) {
            this.freezeEffectOverlay = freezeEffectOverlay;
        }

        @Generated
        public void setFreezeEffectColor(int freezeEffectColor) {
            this.freezeEffectColor = freezeEffectColor;
        }

        @Generated
        private Overlay(boolean freezeEffectOverlay, int freezeEffectColor) {
            this.freezeEffectOverlay = freezeEffectOverlay;
            this.freezeEffectColor = freezeEffectColor;
        }
    }
}

