/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class FBPRainParticle
extends WaterDropParticle
implements IKillableParticle {
    private final double angleY;
    private final float uo;
    private final float vo;
    private final float multiplier;
    private final float targetSize;
    private float height;
    private float lastAlpha;
    private float lastSize;
    private float lastHeight;
    private boolean killToggle;
    private boolean visible;

    public FBPRainParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.sprite = sprite;
        this.lifetime = FBPConstants.RANDOM.nextInt(50, 70);
        this.targetSize = Math.max(FBPConstants.RANDOM.nextFloat(FancyBlockParticles.CONFIG.rain.getSizeMultiplier() - 0.1f, FancyBlockParticles.CONFIG.rain.getSizeMultiplier() + 0.1f) * 4.0f, 0.1f) * (FancyBlockParticles.CONFIG.rain.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.quadSize = 0.0f;
        this.gravity = 0.025f * FancyBlockParticles.CONFIG.rain.getGravityMultiplier();
        Vec3 color = this.level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), 0.0f);
        this.rCol = (float)color.x;
        this.gCol = (float)Mth.clamp((double)(color.y + 0.1), (double)0.1, (double)1.0);
        this.bCol = (float)Mth.clamp((double)(color.y + 0.5), (double)0.5, (double)1.0);
        this.alpha = FancyBlockParticles.CONFIG.rain.getTransparency();
        this.hasPhysics = true;
        this.angleY = FBPConstants.RANDOM.nextDouble() * 45.0;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.multiplier = FancyBlockParticles.CONFIG.rain.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.85f, 1.0f) : 1.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        this.lastHeight = this.height;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.rain.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                ++this.age;
                if (this.y < Minecraft.getInstance().player.getY() - (double)((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue() * 9.0) {
                    this.remove();
                }
                if (!this.onGround) {
                    if (this.age < this.lifetime) {
                        float max = FancyBlockParticles.CONFIG.rain.getSizeMultiplier() * 0.5f;
                        if (this.quadSize < max) {
                            this.quadSize += 0.05f * this.multiplier;
                            if (this.quadSize > max) {
                                this.quadSize = max;
                            }
                            this.height = this.quadSize;
                        }
                    } else {
                        this.remove();
                    }
                }
                this.yd -= 0.04 * (double)this.gravity;
                this.move(this.xd, this.yd, this.zd);
                this.yd *= 1.00025;
                if (this.onGround) {
                    this.xd = 0.0;
                    this.zd = 0.0;
                    if (FancyBlockParticles.CONFIG.rain.isPuddle()) {
                        this.yd = -0.25;
                        if (this.height > 0.075f) {
                            this.height *= 0.725f;
                        }
                        if (this.quadSize < this.targetSize) {
                            this.quadSize += this.targetSize / 10.0f;
                            if (this.quadSize > this.targetSize) {
                                this.quadSize = this.targetSize;
                            }
                        }
                        if (this.quadSize >= this.targetSize / 2.0f) {
                            this.alpha *= 0.75f * this.multiplier;
                            if (this.alpha < 0.01f) {
                                this.remove();
                            }
                        } else {
                            this.alpha = FancyBlockParticles.CONFIG.rain.getTransparency();
                        }
                    } else {
                        this.quadSize *= 0.85f * this.multiplier;
                        this.height = this.quadSize;
                        if (this.alpha >= 0.01f) {
                            this.alpha *= 0.75f * this.multiplier;
                        }
                        if (this.alpha < 0.01f) {
                            this.remove();
                        }
                    }
                } else {
                    this.alpha = FancyBlockParticles.CONFIG.rain.getTransparency();
                }
                BlockState state = this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z).relative(Direction.DOWN));
                if (this.isInLava(this.getBoundingBox()) || (state.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire((BlockState)state)) && this.onGround) {
                    this.remove();
                    Minecraft.getInstance().particleEngine.add(new FBPSmokeParticle.Provider(this.quadSize / 5.0f).createParticle(ParticleTypes.SMOKE, this.level, this.x, this.y, this.z, 0.0, 0.05, 0.0));
                }
            }
        }
        Vec3 vec3 = new Vec3(this.x, Minecraft.getInstance().cameraEntity.getY(), this.z);
        if (Minecraft.getInstance().cameraEntity.position().distanceTo(vec3) > (double)(Math.min(FancyBlockParticles.CONFIG.rain.getSimulationDistance(), (Integer)Minecraft.getInstance().options.simulationDistance().get()) * 16)) {
            this.remove();
        }
        this.visible = Minecraft.getInstance().cameraEntity.position().distanceTo(new Vec3(this.x, Minecraft.getInstance().cameraEntity.getY(), this.z)) <= (double)(Math.min(FancyBlockParticles.CONFIG.rain.getRenderDistance(), (Integer)Minecraft.getInstance().options.renderDistance().get()) * 16);
    }

    private boolean isInLava(AABB box) {
        if (!this.touchingUnloadedChunk()) {
            box = box.deflate(0.001);
            int minX = Mth.floor((double)box.minX);
            int maxX = Mth.ceil((double)box.maxX);
            int minY = Mth.floor((double)box.minY);
            int maxY = Mth.ceil((double)box.maxY);
            int minZ = Mth.floor((double)box.minZ);
            int maxZ = Mth.ceil((double)box.maxZ);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                        FluidState fluidState = this.level.getFluidState(pos);
                        if (!fluidState.is(FluidTags.LAVA) || !((double)(fluidState.getHeight((BlockGetter)this.level, pos) + (float)y) >= box.minY)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.getBoundingBox().inflate(1.0).getCenter();
        return !this.level.isLoaded(BlockPos.containing((double)center.x, (double)center.y, (double)center.z));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    public ParticleRenderType getRenderType() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void render(VertexConsumer buffer, Camera info, float partialTick) {
        if (!this.visible) {
            return;
        }
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.sprite.getU(this.uo / 4.0f);
            v0 = this.sprite.getV(this.vo / 4.0f);
        }
        float u1 = this.sprite.getU((this.uo + 1.0f) / 4.0f);
        float v1 = this.sprite.getV((this.vo + 1.0f) / 4.0f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float width = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize) / 10.0f;
        float height = Mth.lerp((float)partialTick, (float)this.lastHeight, (float)this.height) / 10.0f;
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Vector3d smoothRotation = new Vector3d(0.0, this.angleY, 0.0);
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, posX, posY + (double)height, posZ, width, height, smoothRotation, light, this.rCol, this.gCol, this.bCol, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                return null;
            }
            return new FBPRainParticle(level, x, y, z, 0.1, -FBPConstants.RANDOM.nextDouble(0.65, 0.85), 0.1, Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.WATER.defaultBlockState()));
        }

        @Generated
        public Provider() {
        }
    }
}

