/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samscontrolblocks;

import com.lothrazar.samscontrolblocks.UtilMoveBlock;
import com.lothrazar.samscontrolblocks.proxy.ClientProxy;
import com.lothrazar.samscontrolblocks.proxy.CommonProxy;
import com.lothrazar.samscontrolblocks.proxy.MessageKeyPull;
import com.lothrazar.samscontrolblocks.proxy.MessageKeyPush;
import com.lothrazar.samscontrolblocks.proxy.MessageKeyRotate;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="samscontrolblocks", useMetadata=true, acceptedMinecraftVersions="[1.8]")
public class ModControlBlocks {
    public static final String MODID = "samscontrolblocks";
    public static final String TEXTURE_LOCATION = "samscontrolblocks:";
    @Mod.Instance(value="samscontrolblocks")
    public static ModControlBlocks instance;
    @SidedProxy(clientSide="com.lothrazar.samscontrolblocks.proxy.ClientProxy", serverSide="com.lothrazar.samscontrolblocks.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        String csv = config.getString("push_pull_ignore", MODID, "minecraft:cactus,minecraft:bedrock", "Ignore list for push and pull keys.");
        UtilMoveBlock.seIgnoreBlocksFromString(csv);
        if (config.hasChanged()) {
            config.save();
        }
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(MessageKeyPush.class, MessageKeyPush.class, 0, Side.SERVER);
        network.registerMessage(MessageKeyPull.class, MessageKeyPull.class, 1, Side.SERVER);
        network.registerMessage(MessageKeyRotate.class, MessageKeyRotate.class, 2, Side.SERVER);
        this.registerEventHandlers();
    }

    public static String posToCSV(BlockPos pos) {
        return pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p();
    }

    public static BlockPos stringCSVToBlockPos(String csv) {
        String[] spl = csv.split(",");
        return new BlockPos(Integer.parseInt(spl[0]), Integer.parseInt(spl[1]), Integer.parseInt(spl[2]));
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    private void registerEventHandlers() {
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static void incrementPlayerIntegerNBT(EntityPlayer player, String prop, int inc) {
        int prev = player.getEntityData().func_74762_e(prop);
        player.getEntityData().func_74768_a(prop, prev += inc);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71476_x == null) {
            return;
        }
        BlockPos posMouse = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        if (posMouse == null) {
            return;
        }
        if (ClientProxy.keyPush.func_151468_f()) {
            network.sendToServer((IMessage)new MessageKeyPush(posMouse));
        } else if (ClientProxy.keyPull.func_151468_f()) {
            network.sendToServer((IMessage)new MessageKeyPull(posMouse));
        } else if (ClientProxy.keyTransform.func_151468_f()) {
            network.sendToServer((IMessage)new MessageKeyRotate(posMouse));
        }
    }

    public static void playSoundAt(World world, BlockPos pos, String sound) {
        world.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), sound, 1.0f, 1.0f, false);
    }

    public static ArrayList<Block> getBlockListFromCSV(String csv) {
        String[] ids;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String id : ids = csv.split(",")) {
            Block b = Block.func_149684_b((String)id);
            if (b == null) {
                logger.log(Level.WARN, "getBlockListFromCSV : Block not found : " + id);
                continue;
            }
            blocks.add(b);
        }
        return blocks;
    }

    public static void playSoundAt(Entity player, String sound) {
        player.field_70170_p.func_72956_a(player, sound, 1.0f, 1.0f);
    }

    public static String lang(String name) {
        return StatCollector.func_74838_a((String)name);
    }

    public static void addChatMessage(String string) {
        ModControlBlocks.addChatMessage((IChatComponent)new ChatComponentTranslation(string, new Object[0]));
    }

    public static void addChatMessage(IChatComponent string) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(string);
    }

    public static void addChatMessage(EntityPlayer player, String string) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(string, new Object[0]));
    }

    public static EnumFacing getPlayerFacing(EntityPlayer player) {
        int yaw = (int)player.field_70177_z;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 22;
        int facing = (yaw %= 360) / 45;
        return EnumFacing.func_176731_b((int)(facing / 2));
    }

    public static void spawnParticle(World world, EnumParticleTypes type, BlockPos pos) {
        ModControlBlocks.spawnParticle(world, type, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnParticle(World world, EnumParticleTypes type, double x, double y, double z) {
        for (int countparticles = 0; countparticles <= 10; ++countparticles) {
            world.func_175688_a(type, x + (world.field_73012_v.nextDouble() - 0.5) * 0.8, y + world.field_73012_v.nextDouble() * 1.5 - 0.1, z + (world.field_73012_v.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void execute(EntityPlayer player, String cmd) {
        MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)player, cmd);
    }
}

